/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class ModuleBasedTarget<R extends BuildRootDescriptor>
extends BuildTarget<R> {
    protected final JpsModule myModule;

    public ModuleBasedTarget(ModuleBasedBuildTargetType<?> targetType, @NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/builders/ModuleBasedTarget", "<init>"));
        }
        super(targetType);
        this.myModule = module;
    }

    @NotNull
    public JpsModule getModule() {
        JpsModule jpsModule = this.myModule;
        if (jpsModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/ModuleBasedTarget", "getModule"));
        }
        return jpsModule;
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return false;
    }

    public abstract boolean isTests();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ModuleBasedTarget)) {
            return false;
        }
        ModuleBasedTarget target = (ModuleBasedTarget)o;
        return this.getTargetType() == target.getTargetType() && this.getId().equals(target.getId());
    }

    public int hashCode() {
        return 31 * this.getId().hashCode() + this.getTargetType().hashCode();
    }
}

