/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependenciesRootsEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.util.JpsPathUtil;

public class ProjectPaths {
    private ProjectPaths() {
    }

    public static Collection<File> getCompilationClasspathFiles(ModuleChunk chunk, boolean includeTests, boolean excludeMainModuleOutput, boolean exportedOnly) {
        return ProjectPaths.getClasspathFiles(chunk, JpsJavaClasspathKind.compile((boolean)includeTests), excludeMainModuleOutput, ClasspathPart.WHOLE, exportedOnly);
    }

    public static Collection<File> getPlatformCompilationClasspath(ModuleChunk chunk, boolean excludeMainModuleOutput) {
        return ProjectPaths.getClasspathFiles(chunk, JpsJavaClasspathKind.compile((boolean)chunk.containsTests()), excludeMainModuleOutput, ClasspathPart.BEFORE_JDK, true);
    }

    public static Collection<File> getCompilationClasspath(ModuleChunk chunk, boolean excludeMainModuleOutput) {
        return ProjectPaths.getClasspathFiles(chunk, JpsJavaClasspathKind.compile((boolean)chunk.containsTests()), excludeMainModuleOutput, ClasspathPart.AFTER_JDK, true);
    }

    private static Collection<File> getClasspathFiles(ModuleChunk chunk, JpsJavaClasspathKind kind, boolean excludeMainModuleOutput, ClasspathPart classpathPart, boolean exportedOnly) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (JpsModule module : chunk.getModules()) {
            JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursively();
            if (exportedOnly) {
                enumerator = enumerator.exportedOnly();
            }
            if (classpathPart == ClasspathPart.BEFORE_JDK) {
                enumerator = enumerator.satisfying((Condition)new BeforeJavaSdkItemFilter(module));
            } else if (classpathPart == ClasspathPart.AFTER_JDK) {
                enumerator = enumerator.satisfying((Condition)new AfterJavaSdkItemFilter(module));
            }
            JpsJavaDependenciesRootsEnumerator rootsEnumerator = enumerator.classes();
            if (excludeMainModuleOutput) {
                rootsEnumerator = rootsEnumerator.withoutSelfModuleOutput();
            }
            files.addAll(rootsEnumerator.getRoots());
        }
        if (classpathPart == ClasspathPart.BEFORE_JDK) {
            for (JpsModule module : chunk.getModules()) {
                JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
                if (sdk == null) continue;
                files.addAll(sdk.getParent().getFiles(JpsOrderRootType.COMPILED));
            }
        }
        return files;
    }

    private static void addFile(Set<File> classpath, @Nullable String url) {
        if (url != null) {
            classpath.add(JpsPathUtil.urlToFile((String)url));
        }
    }

    @NotNull
    public static Map<File, String> getSourceRootsWithDependents(ModuleChunk chunk) {
        final boolean includeTests = chunk.containsTests();
        final LinkedHashMap<File, String> result = new LinkedHashMap<File, String>();
        ProjectPaths.processModulesRecursively(chunk, JpsJavaClasspathKind.compile((boolean)includeTests), new Consumer<JpsModule>(){

            public void consume(JpsModule module) {
                for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                    if (!root.getRootType().equals(JavaSourceRootType.SOURCE) && (!includeTests || !root.getRootType().equals(JavaSourceRootType.TEST_SOURCE))) continue;
                    String prefix = ((JavaSourceRootProperties)root.getProperties()).getPackagePrefix();
                    if (!prefix.isEmpty()) {
                        if (!(prefix = prefix.replace('.', '/')).endsWith("/")) {
                            prefix = prefix + "/";
                        }
                    } else {
                        prefix = null;
                    }
                    result.put(JpsPathUtil.urlToFile((String)root.getUrl()), prefix);
                }
            }
        });
        LinkedHashMap<File, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ProjectPaths", "getSourceRootsWithDependents"));
        }
        return linkedHashMap;
    }

    public static Collection<File> getOutputPathsWithDependents(ModuleChunk chunk) {
        final boolean forTests = chunk.containsTests();
        final LinkedHashSet<File> sourcePaths = new LinkedHashSet<File>();
        ProjectPaths.processModulesRecursively(chunk, JpsJavaClasspathKind.compile((boolean)forTests), new Consumer<JpsModule>(){

            public void consume(JpsModule module) {
                ProjectPaths.addFile(sourcePaths, JpsJavaExtensionService.getInstance().getOutputUrl(module, forTests));
            }
        });
        return sourcePaths;
    }

    public static Set<JpsModule> getModulesWithDependentsRecursively(JpsModule module, boolean includeTests) {
        return JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(JpsJavaClasspathKind.compile((boolean)includeTests)).recursively().getModules();
    }

    private static void processModulesRecursively(ModuleChunk chunk, JpsJavaClasspathKind kind, Consumer<JpsModule> processor) {
        JpsJavaExtensionService.getInstance().enumerateDependencies(chunk.getModules()).includedIn(kind).recursively().processModules(processor);
    }

    @Nullable
    public static File getModuleOutputDir(JpsModule module, boolean forTests) {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(module, forTests);
    }

    @Nullable
    public static File getAnnotationProcessorGeneratedSourcesOutputDir(JpsModule module, boolean forTests, ProcessorConfigProfile profile) {
        String sourceDirName = profile.getGeneratedSourcesDirectoryName(forTests);
        if (profile.isOutputRelativeToContentRoot()) {
            ArrayList roots = module.getContentRootsList().getUrls();
            if (roots.isEmpty()) {
                return null;
            }
            if (roots.size() > 1) {
                roots = new ArrayList(roots);
                Collections.sort(roots, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
            }
            File parent = JpsPathUtil.urlToFile((String)((String)roots.get(0)));
            return StringUtil.isEmpty((String)sourceDirName) ? parent : new File(parent, sourceDirName);
        }
        File outputDir = ProjectPaths.getModuleOutputDir(module, forTests);
        if (outputDir == null) {
            return null;
        }
        return StringUtil.isEmpty((String)sourceDirName) ? outputDir : new File(outputDir, sourceDirName);
    }

    private static class AfterJavaSdkItemFilter
    implements Condition<JpsDependencyElement> {
        private JpsModule myModule;
        private boolean mySdkFound;

        private AfterJavaSdkItemFilter(JpsModule module) {
            this.myModule = module;
        }

        public boolean value(JpsDependencyElement dependency) {
            if (this.myModule.equals(dependency.getContainingModule()) && dependency instanceof JpsSdkDependency && ((JpsSdkDependency)dependency).getSdkType().equals(JpsJavaSdkType.INSTANCE)) {
                this.mySdkFound = true;
                return false;
            }
            return this.mySdkFound;
        }
    }

    private static class BeforeJavaSdkItemFilter
    implements Condition<JpsDependencyElement> {
        private JpsModule myModule;
        private boolean mySdkFound;

        private BeforeJavaSdkItemFilter(JpsModule module) {
            this.myModule = module;
        }

        public boolean value(JpsDependencyElement dependency) {
            boolean isJavaSdk;
            boolean bl = isJavaSdk = dependency instanceof JpsSdkDependency && ((JpsSdkDependency)dependency).getSdkType().equals(JpsJavaSdkType.INSTANCE);
            if (this.myModule.equals(dependency.getContainingModule()) && isJavaSdk) {
                this.mySdkFound = true;
            }
            return !this.mySdkFound && !isJavaSdk;
        }
    }

    private static enum ClasspathPart {
        WHOLE,
        BEFORE_JDK,
        AFTER_JDK;

    }
}

