/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairConsumer;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightCheckinHandlerState;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateCopyrightCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final CheckinProjectPanel panel, CommitContext commitContext) {
        CheckinHandler checkinHandler = new CheckinHandler(){

            public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
                final JCheckBox updateCopyrightCb = new JCheckBox("Update copyright");
                return new RefreshableOnComponent(){

                    public JComponent getComponent() {
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.add((Component)updateCopyrightCb, "West");
                        return panel;
                    }

                    public void refresh() {
                    }

                    public void saveState() {
                        UpdateCopyrightCheckinHandlerState.getInstance((Project)panel.getProject()).UPDATE_COPYRIGHT = updateCopyrightCb.isSelected();
                    }

                    public void restoreState() {
                        updateCopyrightCb.setSelected(UpdateCopyrightCheckinHandlerState.getInstance((Project)panel.getProject()).UPDATE_COPYRIGHT);
                    }
                };
            }

            public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
                if (UpdateCopyrightCheckinHandlerState.getInstance((Project)panel.getProject()).UPDATE_COPYRIGHT) {
                    new UpdateCopyrightProcessor(panel.getProject(), null, this.getPsiFiles()).run();
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                return super.beforeCheckin();
            }

            private PsiFile[] getPsiFiles() {
                Collection files = panel.getVirtualFiles();
                ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                PsiManager manager = PsiManager.getInstance((Project)panel.getProject());
                for (VirtualFile file : files) {
                    PsiFile psiFile = manager.findFile(file);
                    if (psiFile == null) continue;
                    psiFiles.add(psiFile);
                }
                return PsiUtilCore.toPsiFileArray(psiFiles);
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/actions/UpdateCopyrightCheckinHandlerFactory", "createHandler"));
        }
        return checkinHandler;
    }
}

