/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;

public class ResourceFileData {
    private final List<ResourceEntry> myValueResources;
    private long myTimestamp;

    public ResourceFileData() {
        this(new ArrayList<ResourceEntry>(), 0L);
    }

    public ResourceFileData(@NotNull List<ResourceEntry> valueResources, long timestamp) {
        if (valueResources == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/util/ResourceFileData", "<init>"));
        }
        this.myValueResources = valueResources;
        this.myTimestamp = timestamp;
    }

    @NotNull
    public List<ResourceEntry> getValueResources() {
        List<ResourceEntry> list = this.myValueResources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/ResourceFileData", "getValueResources"));
        }
        return list;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public void setTimestamp(long timestamp) {
        this.myTimestamp = timestamp;
    }

    public void addValueResource(@NotNull ResourceEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/util/ResourceFileData", "addValueResource"));
        }
        this.myValueResources.add(entry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFileData data = (ResourceFileData)o;
        if (this.myTimestamp != data.myTimestamp) {
            return false;
        }
        return ((Object)this.myValueResources).equals(data.myValueResources);
    }

    public int hashCode() {
        int result = ((Object)this.myValueResources).hashCode();
        result = 31 * result + (int)(this.myTimestamp ^ this.myTimestamp >>> 32);
        return result;
    }
}

