/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidOSProcessHandler
extends BaseOSProcessHandler {
    @NonNls
    private static final String IGNORING = "ignoring";
    @NonNls
    private static final String SKIPPING = "skipping";
    @NonNls
    private static final String DEBUGGABLE_ERROR = "androidmanifest.xml already defines debuggable";
    private final List<String> myInfoMessages;
    private final List<String> myErrorMessages;

    public AndroidOSProcessHandler(@NotNull Process process, @Nullable String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/util/AndroidOSProcessHandler", "<init>"));
        }
        super(process, commandLine, null);
        this.myInfoMessages = new ArrayList<String>();
        this.myErrorMessages = new ArrayList<String>();
    }

    public void notifyTextAvailable(String text, Key outputType) {
        String[] lines;
        super.notifyTextAvailable(text, outputType);
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return;
        }
        for (String line : lines = text.split("[\\n\\r]+")) {
            String l = line.toLowerCase();
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myInfoMessages.add(line);
                continue;
            }
            if (outputType != ProcessOutputTypes.STDERR) continue;
            if (l.contains(IGNORING) || l.contains(SKIPPING) || l.contains(DEBUGGABLE_ERROR)) {
                this.myInfoMessages.add(line);
                continue;
            }
            this.myErrorMessages.add(line);
        }
    }

    @NotNull
    public List<String> getInfoMessages() {
        List<String> list = this.myInfoMessages;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidOSProcessHandler", "getInfoMessages"));
        }
        return list;
    }

    @NotNull
    public List<String> getErrorMessages() {
        List<String> list = this.myErrorMessages;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidOSProcessHandler", "getErrorMessages"));
        }
        return list;
    }
}

