/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildTestingManager {
    private static AndroidBuildTestingManager ourTestingManager;
    private final MyCommandExecutor myCommandExecutor;

    private AndroidBuildTestingManager(@NotNull MyCommandExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/util/AndroidBuildTestingManager", "<init>"));
        }
        this.myCommandExecutor = executor;
    }

    @Nullable
    public static AndroidBuildTestingManager getTestingManager() {
        return ourTestingManager;
    }

    public static void startBuildTesting(@NotNull MyCommandExecutor commandExecutor) {
        if (commandExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/util/AndroidBuildTestingManager", "startBuildTesting"));
        }
        ourTestingManager = new AndroidBuildTestingManager(commandExecutor);
    }

    @NotNull
    public static String arrayToString(@NotNull String[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/util/AndroidBuildTestingManager", "arrayToString"));
        }
        StringBuilder builder = new StringBuilder("[");
        for (String s : array) {
            builder.append('\n').append(s);
        }
        if (array.length > 0) {
            builder.append('\n');
        }
        builder.append("]");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidBuildTestingManager", "arrayToString"));
        }
        return string;
    }

    @NotNull
    public MyCommandExecutor getCommandExecutor() {
        MyCommandExecutor myCommandExecutor = this.myCommandExecutor;
        if (myCommandExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidBuildTestingManager", "getCommandExecutor"));
        }
        return myCommandExecutor;
    }

    public static interface MyCommandExecutor {
        @NotNull
        public Process createProcess(@NotNull String[] var1, @NotNull Map<? extends String, ? extends String> var2);

        public void log(@NotNull String var1);

        public void checkJarContent(@NotNull String var1, @NotNull String var2);
    }
}

