/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.annotations.NotNull;

public final class AndroidIdl {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidIdl");

    private AndroidIdl() {
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> execute(@NotNull IAndroidTarget target, @NotNull String file, @NotNull String outFile, @NotNull String[] sourceRootPaths) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/tools/AndroidIdl", "execute"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/tools/AndroidIdl", "execute"));
        }
        if (outFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/tools/AndroidIdl", "execute"));
        }
        if (sourceRootPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/tools/AndroidIdl", "execute"));
        }
        BuildToolInfo buildToolInfo = target.getBuildToolInfo();
        if (buildToolInfo == null) {
            Map<AndroidCompilerMessageKind, List<String>> map = Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/tools/AndroidIdl", "execute"));
            }
            return map;
        }
        ArrayList<String> commands = new ArrayList<String>();
        String frameworkAidlPath = target.getPath(2);
        commands.add(buildToolInfo.getPath(BuildToolInfo.PathId.AIDL));
        commands.add("-p" + frameworkAidlPath);
        for (String path : sourceRootPaths) {
            commands.add("-I" + path);
        }
        commands.add(file);
        commands.add(outFile);
        LOG.info(AndroidCommonUtils.command2string(commands));
        Map<AndroidCompilerMessageKind, List<String>> map = AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(commands));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/tools/AndroidIdl", "execute"));
        }
        return map;
    }
}

