/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public final class GradleBuilds {
    private static final Logger LOG = Logger.getInstance(GradleBuilds.class);
    @NonNls
    public static final String ASSEMBLE_TRANSLATE_TASK_NAME = "assembleTranslate";
    @NonNls
    public static final String CLEAN_TASK_NAME = "clean";
    @NonNls
    public static final String DEFAULT_ASSEMBLE_TASK_NAME = "assemble";
    @NonNls
    public static final String ENABLE_TRANSLATION_JVM_ARG = "enableTranslation";
    @NonNls
    private static final String TEST_CLASSES_TASK_NAME = "testClasses";
    @NonNls
    public static final String OFFLINE_MODE_OPTION = "--offline";
    @NonNls
    public static final String PARALLEL_BUILD_OPTION = "--parallel";
    @NonNls
    public static final String CONFIGURE_ON_DEMAND_OPTION = "--configure-on-demand";
    @NonNls
    public static final String BUILD_SRC_FOLDER_NAME = "buildSrc";

    private GradleBuilds() {
    }

    public static void findAndAddBuildTask(@NotNull String moduleName, @NotNull BuildMode buildMode, @Nullable String gradleProjectPath, @Nullable JpsAndroidModuleProperties androidFacetProperties, @NotNull List<String> tasks, TestCompileType testCompileType) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/GradleBuilds", "findAndAddBuildTask"));
        }
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/util/GradleBuilds", "findAndAddBuildTask"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/android/tools/idea/gradle/util/GradleBuilds", "findAndAddBuildTask"));
        }
        if (gradleProjectPath == null) {
            String format = "Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.";
            String msg = String.format(format, moduleName);
            LOG.info(msg);
            return;
        }
        String assembleTaskName = null;
        if (androidFacetProperties != null) {
            switch (buildMode) {
                case SOURCE_GEN: {
                    assembleTaskName = androidFacetProperties.SOURCE_GEN_TASK_NAME;
                    break;
                }
                case ASSEMBLE: {
                    assembleTaskName = androidFacetProperties.ASSEMBLE_TASK_NAME;
                    break;
                }
                default: {
                    assembleTaskName = androidFacetProperties.COMPILE_JAVA_TASK_NAME;
                }
            }
        }
        if (Strings.isNullOrEmpty(assembleTaskName) && !BuildMode.SOURCE_GEN.equals((Object)buildMode)) {
            assembleTaskName = DEFAULT_ASSEMBLE_TASK_NAME;
        }
        if (assembleTaskName != null) {
            tasks.add(GradleBuilds.createBuildTask(gradleProjectPath, assembleTaskName));
        }
        switch (testCompileType) {
            case ANDROID_TESTS: {
                if (androidFacetProperties == null || Strings.isNullOrEmpty((String)androidFacetProperties.ASSEMBLE_TEST_TASK_NAME)) break;
                tasks.add(GradleBuilds.createBuildTask(gradleProjectPath, androidFacetProperties.ASSEMBLE_TEST_TASK_NAME));
                break;
            }
            case JAVA_TESTS: {
                tasks.add(GradleBuilds.createBuildTask(gradleProjectPath, TEST_CLASSES_TASK_NAME));
                break;
            }
        }
    }

    @NotNull
    public static String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/GradleBuilds", "createBuildTask"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/util/GradleBuilds", "createBuildTask"));
        }
        if (gradleProjectPath.equals(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleBuilds", "createBuildTask"));
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleBuilds", "createBuildTask"));
        }
        return string;
    }

    public static enum TestCompileType {
        NONE,
        ANDROID_TESTS,
        JAVA_TESTS;

    }
}

