/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MergingExceptionParser
implements PatternAwareOutputParser {
    @Override
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<GradleMessage> messages) throws ParsingFailedException {
        String path;
        int messageIndex;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/parser/androidPlugin/MergingExceptionParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/output/parser/androidPlugin/MergingExceptionParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/output/parser/androidPlugin/MergingExceptionParser", "parse"));
        }
        boolean hasError = false;
        GradleMessage.Kind kind = null;
        if (line.contains("rror: ")) {
            messageIndex = line.indexOf(": Error: ");
            if (messageIndex == -1 && (messageIndex = line.indexOf(": error: ")) == -1) {
                return false;
            }
            kind = GradleMessage.Kind.ERROR;
        } else if (line.contains("arning: ")) {
            messageIndex = line.indexOf(": Warning: ");
            if (messageIndex == -1 && (messageIndex = line.indexOf(": warning: ")) == -1) {
                return false;
            }
            kind = GradleMessage.Kind.WARNING;
        } else {
            return false;
        }
        int lineNumber = -1;
        int column = -1;
        int colon = line.lastIndexOf(58, messageIndex - 1);
        if (colon != -1) {
            int colon2 = line.lastIndexOf(58, colon - 1);
            if (colon2 != -1) {
                String columnString = line.substring(colon + 1, messageIndex);
                String lineString = line.substring(colon2 + 1, colon);
                try {
                    column = Integer.parseInt(columnString);
                    lineNumber = Integer.parseInt(lineString);
                }
                catch (NumberFormatException e) {
                    if (colon2 == 1) {
                        String p = line.substring(0, colon);
                        if (new File(p).exists()) {
                            colon2 = colon;
                        }
                        return false;
                    }
                    return false;
                }
                path = line.substring(0, colon2);
            } else {
                try {
                    lineNumber = Integer.parseInt(line.substring(colon + 1, messageIndex));
                }
                catch (NumberFormatException e) {
                    if (colon == 1) {
                        String p = line.substring(0, messageIndex);
                        if (new File(p).exists()) {
                            colon = messageIndex;
                        }
                        return false;
                    }
                    return false;
                }
                path = line.substring(0, colon);
            }
        } else {
            path = line.substring(0, messageIndex);
        }
        String message = line.substring(messageIndex + 2);
        messages.add(new GradleMessage(kind, message, path, lineNumber, column));
        return true;
    }
}

