/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParserUtil;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DexExceptionParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR = Pattern.compile("UNEXPECTED TOP-LEVEL EXCEPTION:");
    private static final Pattern ALREADY_ADDED_EXCEPTION = Pattern.compile("already added: L(.+);");

    @Override
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<GradleMessage> messages) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser", "parse"));
        }
        Matcher m1 = ERROR.matcher(line);
        if (!m1.matches()) {
            return false;
        }
        String stackTrace = ParserUtil.digestStackTrace(reader);
        if (stackTrace == null) {
            return false;
        }
        Matcher m2 = ALREADY_ADDED_EXCEPTION.matcher(stackTrace);
        if (!m2.matches()) {
            return false;
        }
        String message = String.format("Class %1s has already been added to output. Please remove duplicate copies.", m2.group(1).replace('/', '.').replace('$', '.'));
        messages.add(new GradleMessage(GradleMessage.Kind.ERROR, message, null, -1, -1));
        return true;
    }
}

