/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.BuildFailureParser;
import com.android.tools.idea.gradle.output.parser.GradleOutputParser;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import com.android.tools.idea.gradle.output.parser.aapt.AaptOutputParser;
import com.android.tools.idea.gradle.output.parser.androidPlugin.AndroidPluginOutputParser;
import com.android.tools.idea.gradle.output.parser.androidPlugin.DexExceptionParser;
import com.android.tools.idea.gradle.output.parser.androidPlugin.ManifestMergeFailureParser;
import com.android.tools.idea.gradle.output.parser.androidPlugin.MergingExceptionParser;
import com.android.tools.idea.gradle.output.parser.androidPlugin.XmlValidationErrorParser;
import com.android.tools.idea.gradle.output.parser.javac.JavacOutputParser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BuildOutputParser {
    private static final PatternAwareOutputParser[] PARSERS = new PatternAwareOutputParser[]{new AndroidPluginOutputParser(), new GradleOutputParser(), new AaptOutputParser(), new XmlValidationErrorParser(), new BuildFailureParser(), new ManifestMergeFailureParser(), new DexExceptionParser(), new JavacOutputParser(), new MergingExceptionParser()};

    @NotNull
    public List<GradleMessage> parseGradleOutput(@NotNull String output) {
        String line;
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
        }
        OutputLineReader outputReader = new OutputLineReader(output);
        if (outputReader.getLineCount() == 0) {
            List<GradleMessage> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
            }
            return list;
        }
        ArrayList messages = Lists.newArrayList();
        while ((line = outputReader.readLine()) != null) {
            if (line.isEmpty()) continue;
            boolean handled = false;
            for (PatternAwareOutputParser parser : PARSERS) {
                try {
                    if (!parser.parse(line, outputReader, messages)) continue;
                    handled = true;
                    break;
                }
                catch (ParsingFailedException e) {
                    List<GradleMessage> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
                    }
                    return list;
                }
            }
            if (handled) continue;
            messages.add(new GradleMessage(GradleMessage.Kind.SIMPLE, line));
        }
        ArrayList arrayList = messages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
        }
        return arrayList;
    }
}

