/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output;

import com.google.common.base.Objects;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleMessage {
    @NotNull
    private final Kind myKind;
    @NotNull
    private final String myText;
    @Nullable
    private final String mySourcePath;
    private final int myLineNumber;
    private final int myColumn;

    public GradleMessage(@NotNull Kind kind, @NotNull String text) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/GradleMessage", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/output/GradleMessage", "<init>"));
        }
        this(kind, text, null, -1, -1);
    }

    public GradleMessage(@NotNull Kind kind, @NotNull String text, @Nullable String sourcePath, int lineNumber, int column) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/GradleMessage", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/output/GradleMessage", "<init>"));
        }
        this.myKind = kind;
        this.myText = text;
        this.mySourcePath = sourcePath;
        this.myLineNumber = lineNumber;
        this.myColumn = column;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = this.myKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/GradleMessage", "getKind"));
        }
        return kind;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/GradleMessage", "getText"));
        }
        return string;
    }

    @Nullable
    public String getSourcePath() {
        return this.mySourcePath;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleMessage that = (GradleMessage)o;
        return this.myColumn == that.myColumn && this.myLineNumber == that.myLineNumber && this.myKind == that.myKind && Objects.equal((Object)this.mySourcePath, (Object)that.mySourcePath) && Objects.equal((Object)this.myText, (Object)that.myText);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myColumn, this.myLineNumber, this.myKind, this.mySourcePath, this.myText});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "kind=" + (Object)((Object)this.myKind) + ", text=" + StringUtil.wrapWithDoubleQuote((String)this.myText) + ", sourcePath=" + this.mySourcePath + ", lineNumber=" + this.myLineNumber + ", column=" + this.myColumn + ']';
    }

    public static enum Kind {
        ERROR,
        WARNING,
        INFO,
        STATISTICS,
        SIMPLE;


        @Nullable
        public static Kind findIgnoringCase(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/GradleMessage$Kind", "findIgnoringCase"));
            }
            for (Kind kind : Kind.values()) {
                if (!kind.toString().equalsIgnoreCase(s)) continue;
                return kind;
            }
            return null;
        }
    }
}

