/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.xml.util.IncludedXmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

class RegisterInspectionFix
implements IntentionAction {
    private final PsiClass myPsiClass;
    private final ExtensionPointName<? extends InspectionEP> myEp;
    private static final ImmutableMap<String, String> INTELLIJ_MODULES = ImmutableMap.builder().put((Object)"platform-api", (Object)"PlatformExtensions.xml").put((Object)"platform-impl", (Object)"PlatformExtensions.xml").put((Object)"lang-api", (Object)"LangExtensions.xml").put((Object)"lang-impl", (Object)"LangExtensions.xml").put((Object)"vcs-api", (Object)"VcsExtensions.xml").put((Object)"vcs-impl", (Object)"VcsExtensions.xml").put((Object)"openapi", (Object)"IdeaPlugin.xml").put((Object)"java-impl", (Object)"IdeaPlugin.xml").build();

    RegisterInspectionFix(PsiClass psiClass, ExtensionPointName<? extends InspectionEP> ep) {
        this.myPsiClass = psiClass;
        this.myEp = ep;
    }

    @NotNull
    public String getText() {
        if ("Register inspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "getText"));
        }
        return "Register inspection";
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.component.not.registered.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "invoke"));
        }
        RegisterInspectionFix.choosePluginDescriptor(project, editor, file, new Consumer<DomFileElement<IdeaPlugin>>(){

            public void consume(DomFileElement<IdeaPlugin> element) {
                RegisterInspectionFix.this.doFix((DomFileElement<IdeaPlugin>)element, project, file);
            }
        });
    }

    public static void choosePluginDescriptor(final Project project, Editor editor, PsiFile file, final Consumer<DomFileElement<IdeaPlugin>> consumer) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        List<DomFileElement<IdeaPlugin>> elements = DomService.getInstance().getFileElements(IdeaPlugin.class, project, module.getModuleContentWithDependenciesScope());
        elements = ContainerUtil.filter((Collection)elements, (Condition)new Condition<DomFileElement<IdeaPlugin>>(){

            public boolean value(DomFileElement<IdeaPlugin> element) {
                VirtualFile virtualFile = element.getFile().getVirtualFile();
                return virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
            }
        });
        elements = RegisterInspectionFix.findAppropriateIntelliJModule(module.getName(), elements);
        if (elements.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find plugin descriptor");
            return;
        }
        if (elements.size() == 1) {
            consumer.consume(elements.get(0));
            return;
        }
        BaseListPopupStep<DomFileElement<IdeaPlugin>> popupStep = new BaseListPopupStep<DomFileElement<IdeaPlugin>>("Choose Plugin Descriptor", elements){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public Icon getIconFor(DomFileElement<IdeaPlugin> aValue) {
                return TypePresentationService.getService().getIcon(aValue);
            }

            @NotNull
            public String getTextFor(DomFileElement<IdeaPlugin> value) {
                String name = value.getFile().getName();
                Module module = value.getModule();
                String string = module != null ? name + " [" + module.getName() + "]" : name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix$3", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(DomFileElement<IdeaPlugin> selectedValue, boolean finalChoice) {
                consumer.consume(selectedValue);
                return FINAL_CHOICE;
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
    }

    private static List<DomFileElement<IdeaPlugin>> findAppropriateIntelliJModule(String name, List<DomFileElement<IdeaPlugin>> elements) {
        String extensionsFile = (String)INTELLIJ_MODULES.get((Object)name);
        if (extensionsFile != null) {
            for (DomFileElement<IdeaPlugin> element : elements) {
                if (!element.getFile().getName().equals(extensionsFile)) continue;
                return Collections.singletonList(element);
            }
        }
        return elements;
    }

    private void doFix(DomFileElement<IdeaPlugin> selectedValue, Project project, PsiFile file) {
        final IdeaPlugin plugin = (IdeaPlugin)selectedValue.getRootElement();
        Extension extension = (Extension)new WriteCommandAction<Extension>(project, new PsiFile[]{file}){

            protected void run(Result<Extension> result) throws Throwable {
                Extensions extensions = RegisterInspectionFix.getExtension(plugin, RegisterInspectionFix.this.myEp.getName());
                Extension extension = extensions.addExtension(RegisterInspectionFix.this.myEp.getName());
                XmlTag tag = extension.getXmlTag();
                tag.setAttribute("implementationClass", RegisterInspectionFix.this.myPsiClass.getQualifiedName());
                result.setResult((Object)extension);
            }
        }.execute().throwException().getResultObject();
        PsiNavigateUtil.navigate((PsiElement)extension.getXmlTag());
    }

    public static Extensions getExtension(IdeaPlugin plugin, String epName) {
        List<Extensions> extensionsList = plugin.getExtensions();
        Extensions extensions = null;
        for (Extensions e : extensionsList) {
            String s;
            if (e.getXmlTag() instanceof IncludedXmlTag || (s = e.getDefaultExtensionNs().getStringValue()) == null || !epName.startsWith(s)) continue;
            extensions = e;
            break;
        }
        if (extensions == null) {
            extensions = plugin.addExtensions();
            extensions.getDefaultExtensionNs().setStringValue("com.intellij");
        }
        return extensions;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

