/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.quickfix.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterExtensionFix;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterInspectionFix;

public class RegisterExtensionFixProvider
implements UnusedDeclarationFixProvider {
    @NotNull
    public IntentionAction[] getQuickFixes(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
        }
        if (!(element instanceof PsiIdentifier)) {
            if (IntentionAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            if (IntentionAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        PsiClass parentClass = (PsiClass)parent;
        if (InheritanceUtil.isInheritor((PsiClass)parentClass, (String)LocalInspectionTool.class.getName())) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new RegisterInspectionFix(parentClass, (ExtensionPointName<? extends InspectionEP>)LocalInspectionEP.LOCAL_INSPECTION)};
            if (intentionActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return intentionActionArray;
        }
        if (InheritanceUtil.isInheritor((PsiClass)parentClass, (String)GlobalInspectionTool.class.getName())) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new RegisterInspectionFix(parentClass, (ExtensionPointName<? extends InspectionEP>)InspectionEP.GLOBAL_INSPECTION)};
            if (intentionActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return intentionActionArray;
        }
        ArrayList<ExtensionPointCandidate> candidateList = new ArrayList<ExtensionPointCandidate>();
        RegisterExtensionFixProvider.findExtensionPointCandidatesInHierarchy(parentClass, candidateList, new HashSet<PsiClass>());
        if (!candidateList.isEmpty()) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new RegisterExtensionFix(parentClass, candidateList)};
            if (intentionActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return intentionActionArray;
        }
        if (IntentionAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    private static void findExtensionPointCandidatesInHierarchy(PsiClass aClass, List<ExtensionPointCandidate> list, HashSet<PsiClass> processed) {
        for (PsiClass superClass : aClass.getSupers()) {
            if (!processed.add(superClass) || "java.lang.Object".equals(superClass.getQualifiedName())) continue;
            RegisterExtensionFixProvider.findExtensionPointCandidates(superClass, list);
            RegisterExtensionFixProvider.findExtensionPointCandidatesInHierarchy(superClass, list, processed);
        }
    }

    private static void findExtensionPointCandidates(PsiClass aClass, final List<ExtensionPointCandidate> list) {
        String name = aClass.getQualifiedName();
        if (name == null) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)ProjectScope.getAllScope((Project)aClass.getProject()), (FileType[])new FileType[]{XmlFileType.INSTANCE});
        PsiSearchHelper.SERVICE.getInstance((Project)aClass.getProject()).processUsagesInNonJavaFiles(name, new PsiNonJavaFileReferenceProcessor(){

            public boolean process(PsiFile file, int startOffset, int endOffset) {
                PsiElement element = file.findElementAt(startOffset);
                RegisterExtensionFixProvider.processExtensionPointCandidate(element, list);
                return true;
            }
        }, scope);
    }

    private static void processExtensionPointCandidate(PsiElement element, List<ExtensionPointCandidate> list) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null) {
            return;
        }
        if ("extensionPoint".equals(tag.getName())) {
            String epName = RegisterExtensionFixProvider.getEPName(tag);
            if (epName != null) {
                list.add(new ExtensionPointCandidate(epName));
            }
        } else if ("with".equals(tag.getName())) {
            XmlTag extensionPointTag = tag.getParentTag();
            if (!"extensionPoint".equals(extensionPointTag.getName())) {
                return;
            }
            String attrName = tag.getAttributeValue("attribute");
            String tagName = tag.getAttributeValue("tag");
            String epName = RegisterExtensionFixProvider.getEPName(extensionPointTag);
            String beanClassName = extensionPointTag.getAttributeValue("beanClass");
            if (attrName == null && tagName == null || epName == null) {
                return;
            }
            list.add(new ExtensionPointCandidate(epName, attrName, tagName, beanClassName));
        }
    }

    private static String getEPName(XmlTag tag) {
        String qName = tag.getAttributeValue("qualifiedName");
        if (qName != null) {
            return qName;
        }
        String name = tag.getAttributeValue("name");
        if (name != null) {
            return "com.intellij." + name;
        }
        return null;
    }
}

