/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionNotFoundInspection;
import org.jetbrains.idea.devkit.inspections.IntentionDescriptionNotFoundInspection;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateHtmlDescriptionFix
implements LocalQuickFix,
Iconable {
    private final String myFilename;
    private final Module myModule;
    @NonNls
    private static final String TEMPLATE_NAME = "InspectionDescription.html";
    private final boolean isIntention;

    public CreateHtmlDescriptionFix(String filename, Module module, boolean isIntention) {
        this.myModule = module;
        this.isIntention = isIntention;
        this.myFilename = isIntention ? filename : filename + ".html";
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("create.description.file", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("DevKit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "getFamilyName"));
        }
        return "DevKit";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "applyFix"));
        }
        PsiDirectory[] dirs = this.isIntention ? IntentionDescriptionNotFoundInspection.getIntentionDescriptionsDirs(this.myModule) : InspectionDescriptionNotFoundInspection.getInspectionDescriptionsDirs(this.myModule);
        List<VirtualFile> virtualFiles = CreateHtmlDescriptionFix.getPotentialRoots(this.myModule, dirs);
        final VirtualFile[] roots = this.prepare(VfsUtil.toVirtualFileArray(virtualFiles));
        if (roots.length == 1) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CreateHtmlDescriptionFix.this.createDescription(roots[0]);
                }
            });
        } else {
            ArrayList<String> options = new ArrayList<String>();
            for (VirtualFile file : roots) {
                String path = file.getPresentableUrl() + File.separator + this.getDescriptionFolderName() + File.separator + this.myFilename;
                if (this.isIntention) {
                    path = path + File.separator + "description.html";
                }
                options.add(path);
            }
            final JBList files = new JBList((Object[])ArrayUtil.toStringArray(options));
            files.setSelectionMode(0);
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)files).setTitle(DevKitBundle.message("select.target.location.of.description", this.myFilename)).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    final int index = files.getSelectedIndex();
                    if (0 <= index && index < roots.length) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                CreateHtmlDescriptionFix.this.createDescription(roots[index]);
                            }
                        });
                    }
                }
            }).createPopup();
            Editor editor = FileEditorManager.getInstance((Project)this.myModule.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            popup.showInBestPositionFor(editor);
        }
    }

    private static List<VirtualFile> getPotentialRoots(Module module, PsiDirectory[] dirs) {
        if (dirs.length != 0) {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            for (PsiDirectory dir : dirs) {
                PsiDirectory parent = dir.getParentDirectory();
                if (parent == null) continue;
                result.add(parent.getVirtualFile());
            }
            return result;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        List resourceRoots = rootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (!resourceRoots.isEmpty()) {
            return resourceRoots;
        }
        return rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
    }

    private void createDescription(VirtualFile root) {
        if (!root.isDirectory()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        PsiDirectory psiRoot = psiManager.findDirectory(root);
        PsiDirectory descrRoot = null;
        if (psiRoot == null) {
            return;
        }
        for (PsiDirectory dir : psiRoot.getSubdirectories()) {
            if (!this.getDescriptionFolderName().equals(dir.getName())) continue;
            descrRoot = dir;
            break;
        }
        try {
            VirtualFile file;
            FileTemplate descrTemplate;
            PsiElement template;
            PsiDirectory dir;
            PsiDirectory psiDirectory = descrRoot = descrRoot == null ? psiRoot.createSubdirectory(this.getDescriptionFolderName()) : descrRoot;
            if (this.isIntention && (dir = descrRoot.findSubdirectory(this.myFilename)) == null) {
                descrRoot = descrRoot.createSubdirectory(this.myFilename);
            }
            if ((template = FileTemplateUtil.createFromTemplate((FileTemplate)(descrTemplate = FileTemplateManager.getInstance().getJ2eeTemplate(TEMPLATE_NAME)), (String)(this.isIntention ? "description.html" : this.myFilename), null, (PsiDirectory)descrRoot)) instanceof PsiFile && (file = ((PsiFile)template).getVirtualFile()) != null) {
                FileEditorManager.getInstance((Project)this.myModule.getProject()).openFile(file, true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Icon getIcon(int flags) {
        return new LayeredIcon(new Icon[]{AllIcons.FileTypes.Html, AllIcons.Actions.New});
    }

    private VirtualFile[] prepare(VirtualFile[] roots) {
        ArrayList<VirtualFile> found = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            if (!this.containsDescriptionDir(root)) continue;
            found.add(root);
        }
        return found.size() > 0 ? VfsUtil.toVirtualFileArray(found) : roots;
    }

    private boolean containsDescriptionDir(VirtualFile root) {
        if (!root.isDirectory()) {
            return false;
        }
        for (VirtualFile file : root.getChildren()) {
            if (!file.isDirectory() || !this.getDescriptionFolderName().equals(file.getName())) continue;
            return true;
        }
        return false;
    }

    private String getDescriptionFolderName() {
        return this.isIntention ? "intentionDescriptions" : "inspectionDescriptions";
    }
}

