/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

abstract class BaseFix
implements LocalQuickFix {
    protected final PsiElement myElement;
    protected final boolean myOnTheFly;

    protected BaseFix(PsiElement element, boolean onTheFly) {
        this.myElement = element;
        this.myOnTheFly = onTheFly;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        boolean external;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/quickfix/BaseFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/quickfix/BaseFix", "applyFix"));
        }
        if (!this.myElement.isValid()) {
            return;
        }
        boolean bl = external = descriptor.getPsiElement().getContainingFile() != this.myElement.getContainingFile();
        if (external) {
            VirtualFile[] files;
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiClass.class, (boolean)false);
            ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
            ReadonlyStatusHandler.OperationStatus status = readonlyStatusHandler.ensureFilesWritable(files = new VirtualFile[]{this.myElement.getContainingFile().getVirtualFile()});
            if (status.hasReadonlyFiles()) {
                String className = clazz != null ? clazz.getQualifiedName() : this.myElement.getContainingFile().getName();
                Messages.showMessageDialog((Project)project, (String)DevKitBundle.message("inspections.registration.problems.quickfix.read-only", className), (String)this.getName(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        try {
            this.doFix(project, descriptor, external);
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)("#" + this.getClass().getName())).error((Throwable)e);
        }
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2, boolean var3) throws IncorrectOperationException;
}

