/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.internal.InternalInspection;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToJBColorConstantQuickFix;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToJBColorQuickFix;

public class UseJBColorInspection
extends InternalInspection {
    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection", "buildInternalVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                ProblemDescriptor descriptor = UseJBColorInspection.checkNewExpression(expression, holder.getManager(), isOnTheFly);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
                super.visitNewExpression(expression);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiClass colorClass;
                super.visitReferenceExpression(expression);
                PsiElement colorField = expression.resolve();
                if (colorField != null && colorField instanceof PsiField && ((PsiField)colorField).hasModifierProperty("static") && (colorClass = ((PsiField)colorField).getContainingClass()) != null && Color.class.getName().equals(colorClass.getQualifiedName())) {
                    String text = expression.getText();
                    if (text.contains(".")) {
                        text = text.substring(text.lastIndexOf(46));
                    }
                    if (text.startsWith(".")) {
                        text = text.substring(1);
                    }
                    if (text.equalsIgnoreCase("lightGray")) {
                        text = "LIGHT_GRAY";
                    } else if (text.equalsIgnoreCase("darkGray")) {
                        text = "DARK_GRAY";
                    }
                    ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor((PsiElement)expression, "Change to JBColor." + text.toUpperCase(), (LocalQuickFix)new ConvertToJBColorConstantQuickFix(text.toUpperCase()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    holder.registerProblem(descriptor);
                }
            }
        };
    }

    @Nullable
    private static ProblemDescriptor checkNewExpression(PsiNewExpression expression, InspectionManager manager, boolean isOnTheFly) {
        Project project = manager.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass jbColorClass = facade.findClass(JBColor.class.getName(), GlobalSearchScope.allScope((Project)project));
        PsiType type = expression.getType();
        if (type != null && jbColorClass != null) {
            if (!facade.getResolveHelper().isAccessible((PsiMember)jbColorClass, (PsiElement)expression, jbColorClass)) {
                return null;
            }
            PsiExpressionList arguments = expression.getArgumentList();
            if (arguments != null && "java.awt.Color".equals(type.getCanonicalText())) {
                PsiType parentType;
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiNewExpression && ((parentType = ((PsiNewExpression)parent.getParent()).getType()) == null || JBColor.class.getName().equals(parentType.getCanonicalText()))) {
                    return null;
                }
                return manager.createProblemDescriptor((PsiElement)expression, "Replace with JBColor", (LocalQuickFix)new ConvertToJBColorQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            }
        }
        return null;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Use Darcula aware JBColor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection", "getDisplayName"));
        }
        return "Use Darcula aware JBColor";
    }

    @NotNull
    public String getShortName() {
        if ("UseJBColor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UseJBColorInspection", "getShortName"));
        }
        return "UseJBColor";
    }
}

