/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitleCapitalizationInspection
extends BaseJavaLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Plugin DevKit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection", "getGroupDisplayName"));
        }
        return "Plugin DevKit";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Incorrect dialog title capitalization" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection", "getDisplayName"));
        }
        return "Incorrect dialog title capitalization";
    }

    @NotNull
    public String getShortName() {
        if ("DialogTitleCapitalization" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection", "getShortName"));
        }
        return "DialogTitleCapitalization";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                block8: {
                    String calledName;
                    block7: {
                        PsiReferenceExpression methodExpression = expression.getMethodExpression();
                        calledName = methodExpression.getReferenceName();
                        if (calledName == null) {
                            return;
                        }
                        if (!"setTitle".equals(calledName)) break block7;
                        if (!TitleCapitalizationInspection.isMethodOfClass(expression, new String[]{DialogWrapper.class.getName(), FileChooserDescriptor.class.getName()})) {
                            return;
                        }
                        PsiExpression[] args = expression.getArgumentList().getExpressions();
                        if (args.length == 0) {
                            return;
                        }
                        String titleValue = TitleCapitalizationInspection.getTitleValue(args[0]);
                        if (TitleCapitalizationInspection.hasTitleCapitalization(titleValue)) break block8;
                        holder.registerProblem((PsiElement)args[0], "Dialog title '" + titleValue + "' is not properly capitalized. It should have title capitalization", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new TitleCapitalizationFix(titleValue)});
                        break block8;
                    }
                    if (calledName.startsWith("show") && (calledName.endsWith("Dialog") || calledName.endsWith("Message"))) {
                        if (!TitleCapitalizationInspection.isMethodOfClass(expression, new String[]{Messages.class.getName()})) {
                            return;
                        }
                        PsiExpression[] args = expression.getArgumentList().getExpressions();
                        PsiMethod psiMethod = expression.resolveMethod();
                        assert (psiMethod != null);
                        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                        int parametersLength = parameters.length;
                        for (int i = 0; i < parametersLength; ++i) {
                            PsiParameter parameter = parameters[i];
                            if (!"title".equals(parameter.getName()) || i >= args.length) continue;
                            String titleValue = TitleCapitalizationInspection.getTitleValue(args[i]);
                            if (TitleCapitalizationInspection.hasTitleCapitalization(titleValue)) break;
                            holder.registerProblem((PsiElement)args[i], "Message title '" + titleValue + "' is not properly capitalized. It should have title capitalization", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new TitleCapitalizationFix(titleValue)});
                            break;
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isMethodOfClass(PsiMethodCallExpression expression, String ... classNames) {
        PsiMethod psiMethod = expression.resolveMethod();
        if (psiMethod == null) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String name = containingClass.getQualifiedName();
        return ArrayUtil.contains((String)name, (String[])classNames);
    }

    @Nullable
    private static String getTitleValue(PsiExpression arg) {
        PsiElement result;
        Object value;
        if (arg instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)arg).getValue()) instanceof String) {
            return (String)value;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod psiMethod = ((PsiMethodCallExpression)arg).resolveMethod();
            PsiExpression returnValue = PropertyUtil.getGetterReturnExpression((PsiMethod)psiMethod);
            if (returnValue != null) {
                return TitleCapitalizationInspection.getTitleValue(returnValue);
            }
            Property propertyArgument = TitleCapitalizationInspection.getPropertyArgument((PsiMethodCallExpression)arg);
            if (propertyArgument != null) {
                return propertyArgument.getUnescapedValue();
            }
        }
        if (arg instanceof PsiReferenceExpression && (result = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable && ((PsiVariable)result).hasModifierProperty("final")) {
            return TitleCapitalizationInspection.getTitleValue(((PsiVariable)result).getInitializer());
        }
        return null;
    }

    @Nullable
    private static Property getPropertyArgument(PsiMethodCallExpression arg) {
        PsiExpression[] args = arg.getArgumentList().getExpressions();
        if (args.length > 0) {
            PsiReference[] references;
            for (PsiReference reference : references = args[0].getReferences()) {
                PsiElement element;
                ResolveResult[] resolveResults;
                if (!(reference instanceof PropertyReference) || (resolveResults = ((PropertyReference)reference).multiResolve(false)).length != 1 || !resolveResults[0].isValidResult() || !((element = resolveResults[0].getElement()) instanceof Property)) continue;
                return (Property)element;
            }
        }
        return null;
    }

    private static boolean hasTitleCapitalization(String value) {
        if (value == null) {
            return true;
        }
        value = value.replace("&", "");
        return StringUtil.wordsToBeginFromUpperCase((String)value).equals(value);
    }

    private static class TitleCapitalizationFix
    implements LocalQuickFix {
        private final String myTitleValue;

        public TitleCapitalizationFix(String titleValue) {
            this.myTitleValue = titleValue;
        }

        @NotNull
        public String getName() {
            String string = "Properly capitalize '" + this.myTitleValue + '\'';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection$TitleCapitalizationFix", "getName"));
            }
            return string;
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection$TitleCapitalizationFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection$TitleCapitalizationFix", "applyFix"));
            }
            PsiElement problemElement = descriptor.getPsiElement();
            if (problemElement == null || !problemElement.isValid()) {
                return;
            }
            if (TitleCapitalizationFix.isQuickFixOnReadOnlyFile(problemElement)) {
                return;
            }
            try {
                this.doFix(project, problemElement);
            }
            catch (IncorrectOperationException e) {
                Class<?> aClass = this.getClass();
                String className = aClass.getName();
                Logger logger = Logger.getInstance((String)className);
                logger.error((Throwable)e);
            }
        }

        protected void doFix(Project project, PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
                Object value = literalExpression.getValue();
                if (!(value instanceof String)) {
                    return;
                }
                String string = (String)value;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression newExpression = factory.createExpressionFromText('\"' + StringUtil.wordsToBeginFromUpperCase((String)string) + '\"', element);
                literalExpression.replace((PsiElement)newExpression);
            } else if (element instanceof PsiMethodCallExpression) {
                Property property;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiMethod method = methodCallExpression.resolveMethod();
                PsiExpression returnValue = PropertyUtil.getGetterReturnExpression((PsiMethod)method);
                if (returnValue != null) {
                    this.doFix(project, (PsiElement)returnValue);
                }
                if ((property = TitleCapitalizationInspection.getPropertyArgument(methodCallExpression)) == null) {
                    return;
                }
                String value = property.getUnescapedValue();
                if (value == null) {
                    return;
                }
                String capitalizedString = StringUtil.wordsToBeginFromUpperCase((String)value);
                property.setValue(capitalizedString);
            } else if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (variable.hasModifierProperty("final")) {
                    this.doFix(project, (PsiElement)variable.getInitializer());
                }
            }
        }

        protected static boolean isQuickFixOnReadOnlyFile(PsiElement problemElement) {
            PsiFile containingPsiFile = problemElement.getContainingFile();
            if (containingPsiFile == null) {
                return false;
            }
            VirtualFile virtualFile = containingPsiFile.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            Project project = problemElement.getProject();
            ReadonlyStatusHandler handler = ReadonlyStatusHandler.getInstance((Project)project);
            ReadonlyStatusHandler.OperationStatus status = handler.ensureFilesWritable(new VirtualFile[]{virtualFile});
            return status.hasReadonlyFiles();
        }

        @NotNull
        public String getFamilyName() {
            if ("Properly capitalize" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/TitleCapitalizationInspection$TitleCapitalizationFix", "getFamilyName"));
            }
            return "Properly capitalize";
        }
    }
}

