/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public class PropertyKeyReferenceProvider
extends PsiReferenceProvider {
    private final boolean myTagMode;
    private final String myFallbackKeyName;
    private final String myFallbackGroupName;

    public PropertyKeyReferenceProvider(boolean tagMode, String fallbackKeyName, String fallbackGroupName) {
        this.myTagMode = tagMode;
        this.myFallbackKeyName = fallbackKeyName;
        this.myFallbackGroupName = fallbackGroupName;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider", "acceptsTarget"));
        }
        return target instanceof IProperty;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider", "getReferencesByElement"));
        }
        if (this.myTagMode && element instanceof XmlTag) {
            PsiReference[] psiReferenceArray = this.getTagReferences((XmlTag)element);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttribute xmlAttribute = (XmlAttribute)element.getParent();
            if (element.getTextLength() < 2) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            XmlTag tag = xmlAttribute.getParent();
            String value = null;
            String bundle = tag.getAttributeValue("bundle");
            if ("key".equals(xmlAttribute.getName())) {
                value = xmlAttribute.getValue();
            } else if (this.myFallbackKeyName.equals(xmlAttribute.getName())) {
                value = xmlAttribute.getValue();
                String groupBundle = tag.getAttributeValue(this.myFallbackGroupName);
                if (groupBundle != null) {
                    bundle = groupBundle;
                }
            }
            if (value != null) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyPropertyReference(value, (PsiElement)xmlAttribute.getValueElement(), bundle)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/PropertyKeyReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private PsiReference[] getTagReferences(XmlTag element) {
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parent == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag groupNameTag = parent.findFirstSubTag(this.myFallbackGroupName);
        String bundleName = groupNameTag != null ? groupNameTag.getValue().getTrimmedText() : null;
        return new PsiReference[]{new MyPropertyReference(element.getValue().getText(), (PsiElement)element, bundleName)};
    }

    private static class MyPropertyReference
    extends PropertyReference {
        @Nullable
        private final String myBundleName;

        private MyPropertyReference(String value, PsiElement psiElement, @Nullable String bundleName) {
            super(value, psiElement, bundleName, false);
            this.myBundleName = bundleName;
        }

        @Nullable
        protected List<PropertiesFile> getPropertiesFiles() {
            return this.retrievePropertyFilesByBundleName(this.myBundleName, this.getElement());
        }

        protected List<PropertiesFile> retrievePropertyFilesByBundleName(String bundleName, PsiElement element) {
            List<String> allBundleNames = bundleName == null ? MyPropertyReference.getPluginResourceBundles(element) : Collections.singletonList(bundleName);
            Project project = element.getProject();
            PropertiesReferenceManager propertiesReferenceManager = PropertiesReferenceManager.getInstance((Project)project);
            GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
            ArrayList<PropertiesFile> allPropertiesFiles = new ArrayList<PropertiesFile>();
            for (String name : allBundleNames) {
                List propertiesFiles = propertiesReferenceManager.findPropertiesFiles(searchScope, name, BundleNameEvaluator.DEFAULT);
                allPropertiesFiles.addAll(propertiesFiles);
            }
            return allPropertiesFiles;
        }

        private static List<String> getPluginResourceBundles(PsiElement element) {
            DomElement domElement = DomUtil.getDomElement((PsiElement)element);
            if (domElement == null) {
                return Collections.emptyList();
            }
            DomElement rootElement = DomUtil.getFileElement((DomElement)domElement).getRootElement();
            if (!(rootElement instanceof IdeaPlugin)) {
                return Collections.emptyList();
            }
            IdeaPlugin plugin = (IdeaPlugin)rootElement;
            return ContainerUtil.map(plugin.getResourceBundles(), (Function)new Function<GenericDomValue<String>, String>(){

                public String fun(GenericDomValue<String> value) {
                    return value.getStringValue();
                }
            });
        }
    }
}

