/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.Vendor;

public class PluginXmlDomFileDescription
extends DomFileDescription<IdeaPlugin> {
    private static final DomElementsAnnotator ANNOTATOR = new DomElementsAnnotator(){

        public void annotate(DomElement element, DomElementAnnotationHolder holder) {
            if (element instanceof Extension) {
                this.annotateExtension((Extension)element, holder);
            } else if (element instanceof Vendor) {
                this.annotateVendor((Vendor)element, holder);
            } else if (element instanceof IdeaVersion) {
                this.annotateIdeaVersion((IdeaVersion)element, holder);
            }
        }

        private void annotateIdeaVersion(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
            this.highlightNotUsedAnymore(ideaVersion.getMin(), holder);
            this.highlightNotUsedAnymore(ideaVersion.getMax(), holder);
        }

        private void annotateExtension(Extension extension, DomElementAnnotationHolder holder) {
            ExtensionPoint extensionPoint = extension.getExtensionPoint();
            if (extensionPoint == null) {
                return;
            }
            GenericAttributeValue<PsiClass> interfaceAttribute = extensionPoint.getInterface();
            if (!DomUtil.hasXml(interfaceAttribute)) {
                return;
            }
            PsiClass value = (PsiClass)interfaceAttribute.getValue();
            if (value != null && value.isDeprecated()) {
                Annotation annotation = holder.createAnnotation((DomElement)extension, HighlightSeverity.WARNING, "Deprecated EP");
                annotation.setHighlightType(ProblemHighlightType.LIKE_DEPRECATED);
            }
        }

        private void annotateVendor(Vendor vendor, DomElementAnnotationHolder holder) {
            this.highlightNotUsedAnymore(vendor.getLogo(), holder);
        }

        private void highlightNotUsedAnymore(GenericAttributeValue attributeValue, DomElementAnnotationHolder holder) {
            if (!DomUtil.hasXml((DomElement)attributeValue)) {
                return;
            }
            Annotation annotation = holder.createAnnotation((DomElement)attributeValue, HighlightSeverity.WARNING, "Not used anymore");
            annotation.setHighlightType(ProblemHighlightType.LIKE_DEPRECATED);
        }
    };

    public PluginXmlDomFileDescription() {
        super(IdeaPlugin.class, "idea-plugin", new String[0]);
    }

    public Icon getFileIcon(@Iconable.IconFlags int flags) {
        return AllIcons.Nodes.Plugin;
    }

    @Nullable
    public DomElementsAnnotator createAnnotator() {
        return ANNOTATOR;
    }

    public boolean hasStubs() {
        return true;
    }

    public int getStubVersion() {
        return 2;
    }
}

