/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;

public class PluginFieldNameConverter
extends ResolvingConverter<PsiField> {
    @NotNull
    public Collection<? extends PsiField> getVariants(ConvertContext context) {
        PsiClass aClass = PluginFieldNameConverter.getEPBeanClass(context);
        if (aClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/PluginFieldNameConverter", "getVariants"));
            }
            return list;
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        for (PsiField field : aClass.getAllFields()) {
            PsiClass resolved;
            PsiType type;
            if (field.hasModifierProperty("static") || !((type = field.getType()) instanceof PsiClassType) || (resolved = ((PsiClassType)type).resolve()) == null || !"java.lang.String".equals(resolved.getQualifiedName())) continue;
            result.add(field);
        }
        ArrayList<PsiField> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/PluginFieldNameConverter", "getVariants"));
        }
        return arrayList;
    }

    @Nullable
    public PsiField fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiClass value = PluginFieldNameConverter.getEPBeanClass(context);
        if (value == null) {
            return null;
        }
        PsiField field = value.findFieldByName(s, true);
        if (field != null) {
            return field;
        }
        return PluginFieldNameConverter.findFieldByAttributeValue(value, s);
    }

    private static PsiField findFieldByAttributeValue(PsiClass psiClass, @NotNull String attrNameToFind) {
        if (attrNameToFind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/dom/impl/PluginFieldNameConverter", "findFieldByAttributeValue"));
        }
        for (PsiField psiField : psiClass.getAllFields()) {
            if (!attrNameToFind.equals(PluginFieldNameConverter.getAttributeAnnotationValue(psiField))) continue;
            return psiField;
        }
        return null;
    }

    public static String getAttributeAnnotationValue(PsiField psiField) {
        return PluginFieldNameConverter.getAnnotationValue(psiField, Attribute.class);
    }

    public static String getAnnotationValue(PsiField psiField, Class annotationClass) {
        PsiConstantEvaluationHelper evalHelper = JavaPsiFacade.getInstance((Project)psiField.getProject()).getConstantEvaluationHelper();
        PsiMethod getter = PropertyUtil.findGetterForField((PsiField)psiField);
        PsiMethod setter = PropertyUtil.findSetterForField((PsiField)psiField);
        PsiAnnotation attrAnno = ExtensionDomExtender.findAnnotation(annotationClass, new PsiMember[]{psiField, getter, setter});
        if (attrAnno != null) {
            return ExtensionDomExtender.getStringAttribute(attrAnno, "value", evalHelper);
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable PsiField field, ConvertContext context) {
        return field == null ? null : field.getName();
    }

    @Nullable
    private static PsiClass getEPBeanClass(ConvertContext context) {
        ExtensionPoint ep = (ExtensionPoint)context.getInvocationElement().getParentOfType(ExtensionPoint.class, true);
        if (ep == null) {
            return null;
        }
        PsiClass value = (PsiClass)ep.getBeanClass().getValue();
        if (value == null) {
            return null;
        }
        return value;
    }
}

