/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.make.BuildParticipant;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class PluginBuildParticipant
extends BuildParticipant {
    @NonNls
    private static final String CLASSES = "/classes";
    @NonNls
    private static final String LIB = "/lib/";
    @NonNls
    private static final String LIB_DIRECTORY = "lib";
    private final Module myModule;
    private final PluginBuildConfiguration myPluginBuildConfiguration;

    public PluginBuildParticipant(Module module, PluginBuildConfiguration pluginBuildConfiguration) {
        this.myModule = module;
        this.myPluginBuildConfiguration = pluginBuildConfiguration;
    }

    public Artifact createArtifact(CompileContext context) {
        Sdk sdk = IdeaJdk.findIdeaJdk(ModuleRootManager.getInstance((Module)this.myModule).getSdk());
        if (sdk != null && IdeaJdk.isFromIDEAProject(sdk.getHomePath())) {
            return null;
        }
        if (sdk == null) {
            context.addMessage(CompilerMessageCategory.ERROR, DevKitBundle.message("sdk.type.incorrect", this.myModule.getName()), null, -1, -1);
            return null;
        }
        String outputPath = PluginBuildUtil.getPluginExPath(this.myModule);
        if (outputPath == null) {
            return null;
        }
        if (!this.checkDependencies(context)) {
            return null;
        }
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        ArtifactRootElement root = factory.createArtifactRootElement();
        ConfigFile configFile = this.myPluginBuildConfiguration.getPluginXML();
        if (configFile != null) {
            DomElement domElement;
            XmlDocument document;
            DeploymentUtil.getInstance().checkConfigFile(configFile, context, this.myModule);
            factory.addFileCopy((CompositePackagingElement)root, "META-INF/", VfsUtil.urlToPath((String)configFile.getUrl()));
            XmlFile xmlFile = configFile.getXmlFile();
            if (xmlFile != null && (document = xmlFile.getDocument()) != null && (domElement = DomManager.getDomManager((Project)xmlFile.getProject()).getDomElement(document.getRootTag())) instanceof IdeaPlugin) {
                for (Dependency dependency : ((IdeaPlugin)domElement).getDependencies()) {
                    String file = (String)dependency.getConfigFile().getValue();
                    if (file == null) continue;
                    VirtualFile virtualFile = configFile.getVirtualFile();
                    assert (virtualFile != null);
                    VirtualFile parent = virtualFile.getParent();
                    assert (parent != null);
                    String url = parent.getUrl();
                    factory.addFileCopy((CompositePackagingElement)root, "META-INF/", VfsUtil.urlToPath((String)url) + "/" + file);
                }
            }
        }
        HashSet<Module> modules = new HashSet<Module>();
        PluginBuildUtil.getDependencies(this.myModule, modules);
        CompositePackagingElement classesDir = factory.getOrCreateDirectory((CompositePackagingElement)root, CLASSES);
        for (Module dep : modules) {
            classesDir.addOrFindChild(factory.createModuleOutput(dep));
        }
        classesDir.addOrFindChild(factory.createModuleOutput(this.myModule));
        HashSet<Library> libs = new HashSet<Library>();
        PluginBuildUtil.getLibraries(this.myModule, libs);
        for (Module dependentModule : modules) {
            PluginBuildUtil.getLibraries(dependentModule, libs);
        }
        VirtualFile libDir = sdk.getHomeDirectory().findFileByRelativePath(LIB_DIRECTORY);
        for (Library library : libs) {
            VirtualFile[] files;
            boolean hasDirsOnly = true;
            for (VirtualFile file : files = library.getFiles(OrderRootType.CLASSES)) {
                if (file.getFileSystem() instanceof JarFileSystem) {
                    hasDirsOnly = false;
                    file = ((JarFileSystem)file.getFileSystem()).getVirtualFileForJar(file);
                }
                if (libDir == null || file == null || !VfsUtilCore.isAncestor((VirtualFile)libDir, (VirtualFile)file, (boolean)false)) continue;
                context.addMessage(CompilerMessageCategory.ERROR, DevKitBundle.message("dont.add.idea.libs.to.classpath", file.getName()), null, -1, -1);
            }
            List elements = factory.createLibraryElements(library);
            if (hasDirsOnly) {
                classesDir.addOrFindChildren((Collection)elements);
                continue;
            }
            factory.getOrCreateDirectory((CompositePackagingElement)root, LIB).addOrFindChildren((Collection)elements);
        }
        return new ArtifactImpl(this.getArtifactName(), (ArtifactType)PlainArtifactType.getInstance(), false, (CompositePackagingElement)root, FileUtil.toSystemIndependentName((String)outputPath));
    }

    private String getArtifactName() {
        return this.myModule.getName() + ":plugin";
    }

    private boolean checkDependencies(CompileContext context) {
        Module[] wrongSetDependencies = PluginBuildUtil.getWrongSetDependencies(this.myModule);
        if (wrongSetDependencies.length != 0) {
            boolean realProblems = false;
            String pluginId = DescriptorUtil.getPluginId(this.myModule);
            for (Module dependency : wrongSetDependencies) {
                if (!PluginModuleType.isOfType(dependency)) {
                    realProblems = true;
                    context.addMessage(CompilerMessageCategory.ERROR, DevKitBundle.message("incorrect.dependency.non-plugin-module", dependency.getName(), this.myModule.getName()), null, -1, -1);
                    continue;
                }
                XmlFile pluginXml = PluginModuleType.getPluginXml(dependency);
                boolean isDeclared = false;
                if (pluginXml != null) {
                    XmlTag[] dependencies;
                    XmlTag rootTag = pluginXml.getDocument().getRootTag();
                    for (XmlTag dep : dependencies = rootTag != null ? rootTag.findSubTags("depends") : XmlTag.EMPTY) {
                        if (!dep.getValue().getTrimmedText().equals(pluginId)) continue;
                        isDeclared = true;
                        break;
                    }
                }
                if (isDeclared) continue;
                realProblems = true;
                context.addMessage(CompilerMessageCategory.ERROR, DevKitBundle.message("incorrect.dependency.not-declared", dependency.getName(), this.myModule.getName()), null, -1, -1);
            }
            if (realProblems) {
                return false;
            }
        }
        return true;
    }
}

