/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final int DEFAULT_MAX_CAPACITY;
    private static final int INITIAL_CAPACITY;
    private final int maxCapacity;
    private final ThreadLocal<Stack<T>> threadLocal = new ThreadLocal<Stack<T>>(){

        @Override
        protected Stack<T> initialValue() {
            return new Stack(Recycler.this, Thread.currentThread(), Recycler.this.maxCapacity);
        }
    };

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY);
    }

    protected Recycler(int maxCapacity) {
        if (maxCapacity <= 0) {
            maxCapacity = 0;
        }
        this.maxCapacity = maxCapacity;
    }

    public final T get() {
        Stack<T> stack = this.threadLocal.get();
        T o = stack.pop();
        if (o == null) {
            o = this.newObject(stack);
        }
        return o;
    }

    public final boolean recycle(T o, Handle<T> handle) {
        Stack stack = (Stack)handle;
        if (stack.parent != this) {
            return false;
        }
        if (Thread.currentThread() != stack.thread) {
            return false;
        }
        stack.push(o);
        return true;
    }

    protected abstract T newObject(Handle<T> var1);

    static {
        int maxCapacity = SystemPropertyUtil.getInt("io.netty.recycler.maxCapacity", 0);
        if (maxCapacity <= 0) {
            maxCapacity = 262144;
        }
        DEFAULT_MAX_CAPACITY = maxCapacity;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.recycler.maxCapacity: {}", (Object)DEFAULT_MAX_CAPACITY);
        }
        INITIAL_CAPACITY = Math.min(DEFAULT_MAX_CAPACITY, 256);
    }

    static final class Stack<T>
    implements Handle<T> {
        private T[] elements;
        private int size;
        private final int maxCapacity;
        private final Map<T, Boolean> map;
        final Recycler<T> parent;
        final Thread thread;

        Stack(Recycler<T> parent, Thread thread, int maxCapacity) {
            this.parent = parent;
            this.thread = thread;
            this.maxCapacity = maxCapacity;
            this.elements = Stack.newArray(INITIAL_CAPACITY);
            boolean assertionEnabled = false;
            if (!$assertionsDisabled) {
                assertionEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.map = assertionEnabled ? new IdentityHashMap<T, Boolean>(INITIAL_CAPACITY) : null;
        }

        @Override
        public void recycle(T object) {
            this.parent.recycle(object, this);
        }

        T pop() {
            int size = this.size;
            if (size == 0) {
                return null;
            }
            T ret = this.elements[--size];
            this.elements[size] = null;
            assert (this.map == null || this.map.remove(ret) != null);
            this.size = size;
            return ret;
        }

        void push(T o) {
            assert (this.map == null || this.map.put(o, Boolean.TRUE) == null) : "recycled already";
            int size = this.size;
            if (size == this.elements.length) {
                if (size == this.maxCapacity) {
                    return;
                }
                T[] newElements = Stack.newArray(Math.min(this.maxCapacity, size << 1));
                System.arraycopy(this.elements, 0, newElements, 0, size);
                this.elements = newElements;
            }
            this.elements[size] = o;
            this.size = size + 1;
        }

        private static <T> T[] newArray(int length) {
            return new Object[length];
        }
    }

    public static interface Handle<T> {
        public void recycle(T var1);
    }
}

