/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.memcache.AbstractMemcacheObject;
import io.netty.handler.codec.memcache.MemcacheContent;
import io.netty.util.internal.StringUtil;

public class DefaultMemcacheContent
extends AbstractMemcacheObject
implements MemcacheContent {
    private final ByteBuf content;

    public DefaultMemcacheContent(ByteBuf content) {
        if (content == null) {
            throw new NullPointerException("Content cannot be null.");
        }
        this.content = content;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public MemcacheContent copy() {
        return new DefaultMemcacheContent(this.content.copy());
    }

    @Override
    public MemcacheContent duplicate() {
        return new DefaultMemcacheContent(this.content.duplicate());
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public MemcacheContent retain() {
        this.content.retain();
        return this;
    }

    @Override
    public MemcacheContent retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    @Override
    public MemcacheContent touch() {
        this.content.touch();
        return this;
    }

    @Override
    public MemcacheContent touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(data: " + this.content() + ", getDecoderResult: " + this.getDecoderResult() + ')';
    }
}

