/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal.web;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;

public class WebResourceImpl
implements WebConfiguration.WebResource {
    @NotNull
    private final String myWarDirectory;
    @NotNull
    private final String myRelativePath;
    @NotNull
    private final File file;

    public WebResourceImpl(@NotNull String warDirectory, @NotNull String relativePath, @NotNull File file) {
        if (warDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/tooling/internal/web/WebResourceImpl", "<init>"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/tooling/internal/web/WebResourceImpl", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/tooling/internal/web/WebResourceImpl", "<init>"));
        }
        this.myWarDirectory = warDirectory;
        this.myRelativePath = relativePath;
        this.file = file;
    }

    @NotNull
    public String getWarDirectory() {
        String string = this.myWarDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/tooling/internal/web/WebResourceImpl", "getWarDirectory"));
        }
        return string;
    }

    @NotNull
    public String getRelativePath() {
        String string = this.myRelativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/tooling/internal/web/WebResourceImpl", "getRelativePath"));
        }
        return string;
    }

    @NotNull
    public File getFile() {
        File file = this.file;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/tooling/internal/web/WebResourceImpl", "getFile"));
        }
        return file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebResourceImpl)) {
            return false;
        }
        WebResourceImpl resource = (WebResourceImpl)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.myWarDirectory != resource.myWarDirectory) {
            return false;
        }
        return this.myRelativePath.equals(resource.myRelativePath);
    }

    public int hashCode() {
        int result = this.myWarDirectory.hashCode();
        result = 31 * result + this.myRelativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "WebResourceImpl{myWarDirectory=" + this.myWarDirectory + ", warRelativePath='" + this.myRelativePath + '\'' + ", file=" + this.file + '}';
    }
}

