/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.util.ServiceLoader;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;

public class ExtraModelBuilder
implements ToolingModelBuilder {
    private static final String RANGE_TOKEN = " <=> ";
    private static ServiceLoader<ModelBuilderService> buildersLoader = ServiceLoader.load(ModelBuilderService.class, ExtraModelBuilder.class.getClassLoader());
    @NotNull
    private final GradleVersion myCurrentGradleVersion;

    public ExtraModelBuilder() {
        this.myCurrentGradleVersion = GradleVersion.current();
    }

    public ExtraModelBuilder(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "<init>"));
        }
        this.myCurrentGradleVersion = gradleVersion;
    }

    public boolean canBuild(String modelName) {
        for (ModelBuilderService service : buildersLoader) {
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            return true;
        }
        return false;
    }

    public Object buildAll(String modelName, Project project) {
        for (ModelBuilderService service : buildersLoader) {
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            try {
                return service.buildAll(modelName, project);
            }
            catch (Exception e) {
                ErrorMessageBuilder builderError = service.getErrorMessageBuilder(project, e);
                project.getLogger().error(builderError.build());
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    private boolean isVersionMatch(@NotNull ModelBuilderService builderService) {
        if (builderService == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "isVersionMatch"));
        }
        TargetVersions targetVersions = builderService.getClass().getAnnotation(TargetVersions.class);
        if (targetVersions == null || targetVersions.value() == null || targetVersions.value().isEmpty()) {
            return true;
        }
        GradleVersion current = ExtraModelBuilder.adjust(this.myCurrentGradleVersion, targetVersions.checkBaseVersions());
        if (targetVersions.value().endsWith("+")) {
            String minVersion = targetVersions.value().substring(0, targetVersions.value().length() - 1);
            return ExtraModelBuilder.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0;
        }
        int rangeIndex = targetVersions.value().indexOf(RANGE_TOKEN);
        if (rangeIndex != -1) {
            String minVersion = targetVersions.value().substring(0, rangeIndex);
            String maxVersion = targetVersions.value().substring(rangeIndex + RANGE_TOKEN.length());
            return ExtraModelBuilder.compare(current, minVersion, targetVersions.checkBaseVersions()) >= 0 && ExtraModelBuilder.compare(current, maxVersion, targetVersions.checkBaseVersions()) <= 0;
        }
        return ExtraModelBuilder.compare(current, targetVersions.value(), targetVersions.checkBaseVersions()) == 0;
    }

    private static int compare(@NotNull GradleVersion gradleVersion, @NotNull String otherGradleVersion, boolean checkBaseVersions) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "compare"));
        }
        if (otherGradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "compare"));
        }
        return gradleVersion.compareTo(ExtraModelBuilder.adjust(GradleVersion.version((String)otherGradleVersion), checkBaseVersions));
    }

    private static GradleVersion adjust(@NotNull GradleVersion version, boolean checkBaseVersions) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "adjust"));
        }
        return checkBaseVersions ? version.getBaseVersion() : version;
    }
}

