/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.ModuleLibrary;
import org.gradle.plugins.ide.idea.model.Path;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.BuildScriptClasspathModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;

public class ModelBuildScriptClasspathBuilderImpl
implements ModelBuilderService {
    private static final String COMPILE_SCOPE = "COMPILE";
    private static final String PLUS_CONFIGURATION = "plus";
    private static final String MINUS_CONFIGURATION = "minus";
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private final Map<String, BuildScriptClasspathModelImpl> cache = new ConcurrentHashMap<String, BuildScriptClasspathModelImpl>();

    public boolean canBuild(String modelName) {
        return BuildScriptClasspathModel.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(String modelName, Project project) {
        BuildScriptClasspathModelImpl buildScriptClasspath = this.cache.get(project.getPath());
        if (buildScriptClasspath != null) {
            return buildScriptClasspath;
        }
        buildScriptClasspath = new BuildScriptClasspathModelImpl();
        File gradleHomeDir = project.getGradle().getGradleHomeDir();
        buildScriptClasspath.setGradleHomeDir(gradleHomeDir);
        buildScriptClasspath.setGradleVersion(GradleVersion.current().getVersion());
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().getPlugin(IdeaPlugin.class);
        if (ideaPlugin != null) {
            Configuration configuration;
            Configuration classpathConfiguration;
            BuildScriptClasspathModelImpl parentBuildScriptClasspath;
            Project parent = project.getParent();
            if (parent != null && (parentBuildScriptClasspath = (BuildScriptClasspathModelImpl)this.buildAll(modelName, parent)) != null) {
                for (ClasspathEntryModel classpathEntryModel : parentBuildScriptClasspath.getClasspath()) {
                    buildScriptClasspath.add(classpathEntryModel);
                }
            }
            if ((classpathConfiguration = (Configuration)project.getBuildscript().getConfigurations().findByName(CLASSPATH_CONFIGURATION_NAME)) == null) {
                return null;
            }
            IdeaModule ideaModule = ideaPlugin.getModel().getModule();
            ConfigurationContainer configurations = ideaModule.getProject().getConfigurations();
            if (classpathConfiguration.getState() == Configuration.State.UNRESOLVED) {
                configuration = classpathConfiguration;
                configurations.add((Object)configuration);
            } else {
                configuration = (Configuration)configurations.maybeCreate(UUID.randomUUID().toString());
                configuration.getDependencies().addAll((Collection)classpathConfiguration.getAllDependencies());
                configuration.getArtifacts().addAll((Collection)classpathConfiguration.getAllArtifacts());
            }
            List<Configuration> plusConfigurations = Collections.singletonList(configuration);
            HashMap scopes = new HashMap(ideaModule.getScopes());
            HashMap buildScriptScope = new HashMap();
            HashMap<String, List<Object>> plusConfiguration = new HashMap<String, List<Object>>();
            plusConfiguration.put(PLUS_CONFIGURATION, plusConfigurations);
            if (scopes.get(COMPILE_SCOPE) != null) {
                plusConfiguration.put(MINUS_CONFIGURATION, (List<Object>)((Map)scopes.get(COMPILE_SCOPE)).get(PLUS_CONFIGURATION));
            }
            buildScriptScope.put(COMPILE_SCOPE, plusConfiguration);
            ideaModule.setScopes(buildScriptScope);
            Set buildScriptDependencies = ideaModule.resolveDependencies();
            for (Dependency dependency : buildScriptDependencies) {
                ModuleLibrary moduleLibrary;
                if (!(dependency instanceof ModuleLibrary) || !COMPILE_SCOPE.equals((moduleLibrary = (ModuleLibrary)dependency).getScope())) continue;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.convert(moduleLibrary.getClasses()), ModelBuildScriptClasspathBuilderImpl.convert(moduleLibrary.getSources()), ModelBuildScriptClasspathBuilderImpl.convert(moduleLibrary.getJavadoc())));
            }
            ideaModule.setScopes(scopes);
            configurations.remove((Object)configuration);
        }
        this.cache.put(project.getPath(), buildScriptClasspath);
        return buildScriptClasspath;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl", "getErrorMessageBuilder"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl", "getErrorMessageBuilder"));
        }
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project build classpath resolve errors").withDescription("Unable to resolve additional buildscript classpath dependencies");
        if (errorMessageBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl", "getErrorMessageBuilder"));
        }
        return errorMessageBuilder;
    }

    private static Set<String> convert(Set<Path> paths) {
        HashSet<String> result = new HashSet<String>(paths.size());
        for (Path path : paths) {
            result.add(path.getRelPath());
        }
        return result;
    }
}

