/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.JavaProjectStructureDetector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.importProject.CloudGitChooseAccountStep;
import com.intellij.remoteServer.util.importProject.CloudGitJavaSourceRoot;
import com.intellij.remoteServer.util.importProject.CloudGitProjectRoot;
import git4idea.GitPlatformFacade;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CloudGitProjectStructureDetectorBase<DC extends CloudDeploymentNameConfiguration>
extends ProjectStructureDetector {
    private final JavaProjectStructureDetector myJavaDetector = new JavaProjectStructureDetector();
    private final String myId;
    private final String myJavaSourceRootTypeName;
    private final CloudGitDeploymentDetector myDeploymentDetector;

    protected CloudGitProjectStructureDetectorBase(ServerType serverType, CloudGitDeploymentDetector deploymentDetector) {
        this.myId = serverType.getPresentableName();
        this.myJavaSourceRootTypeName = "Java/" + this.myId;
        this.myDeploymentDetector = deploymentDetector;
    }

    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectRoots"));
        }
        this.detectApplicationRoot(dir, result);
        for (DetectedProjectRoot projectRoot : result) {
            if (!(projectRoot instanceof CloudGitProjectRoot) || !FileUtil.isAncestor((File)projectRoot.getDirectory(), (File)dir, (boolean)true)) continue;
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = this.detectJavaRoots(dir, children, base, result);
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    private void detectApplicationRoot(@NotNull File dir, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectApplicationRoot"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectApplicationRoot"));
        }
        VirtualFile repositoryRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
        if (repositoryRoot == null) {
            return;
        }
        File gitDir = new File(dir, ".git");
        if (!gitDir.exists()) {
            return;
        }
        Project project = ProjectManager.getInstance().getDefaultProject();
        GitRepository repository = GitRepositoryImpl.getLightInstance((VirtualFile)repositoryRoot, (Project)project, (GitPlatformFacade)((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)), (Disposable)project);
        repository.update();
        List<String> applicationNames = this.myDeploymentDetector.collectApplicationNames(repository);
        if (applicationNames.isEmpty()) {
            return;
        }
        result.add(new CloudGitProjectRoot(this.myId, this.myJavaSourceRootTypeName, dir, repositoryRoot, applicationNames.get(0)));
    }

    private ProjectStructureDetector.DirectoryProcessingResult detectJavaRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectJavaRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectJavaRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectJavaRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetectorBase", "detectJavaRoots"));
        }
        ArrayList detectedJavaRoots = new ArrayList();
        ProjectStructureDetector.DirectoryProcessingResult processingResult = this.myJavaDetector.detectRoots(dir, children, base, detectedJavaRoots);
        for (DetectedProjectRoot detectedJavaRoot : detectedJavaRoots) {
            if (!(detectedJavaRoot instanceof JavaModuleSourceRoot)) continue;
            result.add((DetectedProjectRoot)new CloudGitJavaSourceRoot(this.myJavaSourceRootTypeName, (JavaModuleSourceRoot)detectedJavaRoot));
        }
        return processingResult;
    }

    public String getDetectorId() {
        return this.myId;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        return Collections.singletonList(new CloudGitChooseAccountStep(this, builder, projectDescriptor));
    }

    public abstract CloudAccountSelectionEditor<?, DC, ?> createAccountSelectionEditor();

    public abstract DC createDeploymentConfiguration();
}

