/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.importProject.CloudGitProjectRoot;
import com.intellij.remoteServer.util.importProject.CloudGitProjectStructureDetectorBase;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.MultiMap;
import git4idea.actions.GitInit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CloudGitChooseAccountStep<DC extends CloudDeploymentNameConfiguration>
extends ModuleWizardStep {
    private JPanel myAccountSelectionPanelPlaceHolder;
    private JPanel myMainPanel;
    private JLabel myTitleLabel;
    private final CloudGitProjectStructureDetectorBase<DC> myDetector;
    private final ProjectFromSourcesBuilder myBuilder;
    private final ProjectDescriptor myProjectDescriptor;
    private CloudAccountSelectionEditor<?, DC, ?> myEditor;

    public CloudGitChooseAccountStep(CloudGitProjectStructureDetectorBase<DC> detector, ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor) {
        this.myDetector = detector;
        this.myBuilder = builder;
        this.myProjectDescriptor = projectDescriptor;
        this.$$$setupUI$$$();
        this.myTitleLabel.setText(CloudBundle.getText((String)"choose.account.title", (Object[])new Object[]{detector.getDetectorId()}));
        this.myEditor = detector.createAccountSelectionEditor();
        this.myAccountSelectionPanelPlaceHolder.add(this.myEditor.getMainPanel());
        this.myEditor.initUI();
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void updateDataModel() {
        Collection roots = this.myBuilder.getProjectRoots(this.myDetector);
        CloudGitProjectRoot lastProjectRoot = null;
        MultiMap project2sourceRoots = new MultiMap();
        for (DetectedProjectRoot root : roots) {
            if (root instanceof CloudGitProjectRoot) {
                lastProjectRoot = (CloudGitProjectRoot)root;
                project2sourceRoots.put((Object)lastProjectRoot, new ArrayList());
                continue;
            }
            if (!(root instanceof DetectedSourceRoot)) continue;
            project2sourceRoots.putValue((Object)lastProjectRoot, (Object)((DetectedSourceRoot)root));
        }
        ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
        for (Map.Entry project2sourceRootsEntry : project2sourceRoots.entrySet()) {
            final CloudGitProjectRoot projectRoot = (CloudGitProjectRoot)((Object)project2sourceRootsEntry.getKey());
            final File directory = projectRoot.getDirectory();
            ModuleDescriptor moduleDescriptor = new ModuleDescriptor(directory, StdModuleTypes.JAVA, (Collection)project2sourceRootsEntry.getValue());
            final String applicationName = projectRoot.getApplicationName();
            moduleDescriptor.addConfigurationUpdater(new ModuleBuilder.ModuleConfigurationUpdater(){

                public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                    if (module == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/importProject/CloudGitChooseAccountStep$1", "update"));
                    }
                    if (rootModel == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/util/importProject/CloudGitChooseAccountStep$1", "update"));
                    }
                    CloudGitChooseAccountStep.this.createRunConfiguration(module, applicationName);
                    GitInit.refreshAndConfigureVcsMappings((Project)module.getProject(), (VirtualFile)projectRoot.getRepositoryRoot(), (String)directory.getAbsolutePath());
                }
            });
            modules.add(moduleDescriptor);
        }
        this.myProjectDescriptor.setModules(modules);
    }

    public boolean validate() throws ConfigurationException {
        this.myEditor.validate();
        return super.validate();
    }

    private void createRunConfiguration(Module module, String applicationName) {
        DC deploymentConfiguration = this.myDetector.createDeploymentConfiguration();
        boolean defaultName = module.getName().equals(applicationName);
        deploymentConfiguration.setDefaultDeploymentName(defaultName);
        if (!defaultName) {
            deploymentConfiguration.setDeploymentName(applicationName);
        }
        this.myEditor.createRunConfiguration(module, deploymentConfiguration);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Choose <cloud> account:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAccountSelectionPanelPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

