/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CloudGitDeploymentDetector {
    private final Pattern myGitUrlPattern;

    public CloudGitDeploymentDetector(Pattern gitUrlPattern) {
        this.myGitUrlPattern = gitUrlPattern;
    }

    public List<String> collectApplicationNames(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudGitDeploymentDetector", "collectApplicationNames"));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (GitRemote remote : repository.getRemotes()) {
            for (String url : remote.getUrls()) {
                Matcher matcher = this.myGitUrlPattern.matcher(url);
                if (!matcher.matches()) continue;
                result.add(matcher.group(1));
            }
        }
        return result;
    }
}

