/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ant;

import com.intellij.ant.PrefixedPath;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.instrumentation.InstrumenterClassWriter;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class Javac2
extends Javac {
    public static final String PROPERTY_INSTRUMENTATION_INCLUDE_JAVA_RUNTIME = "javac2.instrumentation.includeJavaRuntime";
    private ArrayList myFormFiles;
    private List myNestedFormPathList;
    private boolean instrumentNotNull = true;

    protected boolean areJavaClassesCompiled() {
        return true;
    }

    private void unsupportedOptionMessage(String optionName) {
        if (!this.areJavaClassesCompiled()) {
            this.log("The option " + optionName + " is not supported by InstrumentIdeaExtensions task", 0);
        }
    }

    public boolean getInstrumentNotNull() {
        return this.instrumentNotNull;
    }

    public void setInstrumentNotNull(boolean instrumentNotNull) {
        this.instrumentNotNull = instrumentNotNull;
    }

    public void setDebugLevel(String v) {
        this.unsupportedOptionMessage("debugLevel");
        super.setDebugLevel(v);
    }

    public void setListfiles(boolean list) {
        this.unsupportedOptionMessage("listFiles");
        super.setListfiles(list);
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.unsupportedOptionMessage("memoryInitialSize");
        super.setMemoryInitialSize(memoryInitialSize);
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.unsupportedOptionMessage("memoryMaximumSize");
        super.setMemoryMaximumSize(memoryMaximumSize);
    }

    public void setEncoding(String encoding) {
        this.unsupportedOptionMessage("encoding");
        super.setEncoding(encoding);
    }

    public void setOptimize(boolean optimize) {
        this.unsupportedOptionMessage("optimize");
        super.setOptimize(optimize);
    }

    public void setDepend(boolean depend) {
        this.unsupportedOptionMessage("depend");
        super.setDepend(depend);
    }

    public void setFork(boolean f) {
        this.unsupportedOptionMessage("fork");
        super.setFork(f);
    }

    public void setExecutable(String forkExec) {
        this.unsupportedOptionMessage("executable");
        super.setExecutable(forkExec);
    }

    public void setCompiler(String compiler) {
        this.unsupportedOptionMessage("compiler");
        super.setCompiler(compiler);
    }

    public void setNestedformdirs(List nestedformdirs) {
        this.myNestedFormPathList = nestedformdirs;
    }

    public List getNestedformdirs() {
        return this.myNestedFormPathList;
    }

    public PrefixedPath createNestedformdirs() {
        PrefixedPath p = new PrefixedPath(this.getProject());
        if (this.myNestedFormPathList == null) {
            this.myNestedFormPathList = new ArrayList();
        }
        this.myNestedFormPathList.add(p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compile() {
        InstrumentationClassFinder finder;
        if (this.areJavaClassesCompiled()) {
            super.compile();
        }
        if ((finder = this.buildClasspathClassLoader()) == null) {
            return;
        }
        try {
            this.instrumentForms(finder);
            if (this.getInstrumentNotNull()) {
                int instrumented = this.instrumentNotNull(this.getDestdir(), finder);
                this.log("Added @NotNull assertions to " + instrumented + " files", 2);
            }
        }
        finally {
            finder.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentForms(InstrumentationClassFinder finder) {
        ArrayList formsToInstrument = this.myFormFiles;
        if (formsToInstrument.size() == 0) {
            this.log("No forms to instrument found", 3);
            return;
        }
        HashMap<String, File> class2form = new HashMap<String, File>();
        for (int i = 0; i < formsToInstrument.size(); ++i) {
            LwRootContainer rootContainer;
            File formFile = (File)formsToInstrument.get(i);
            this.log("compiling form " + formFile.getAbsolutePath(), 3);
            try {
                rootContainer = Utils.getRootContainer(formFile.toURI().toURL(), (PropertiesProvider)new CompiledClassPropertiesProvider(finder.getLoader()));
            }
            catch (AlienFormFileException e) {
                continue;
            }
            catch (Exception e) {
                this.fireError("Cannot process form file " + formFile.getAbsolutePath() + ". Reason: " + e);
                continue;
            }
            String classToBind = rootContainer.getClassToBind();
            if (classToBind == null) continue;
            String name = classToBind.replace('.', '/');
            File classFile = this.getClassFile(name);
            if (classFile == null) {
                this.log(formFile.getAbsolutePath() + ": Class to bind does not exist: " + classToBind, 1);
                continue;
            }
            File alreadyProcessedForm = (File)class2form.get(classToBind);
            if (alreadyProcessedForm != null) {
                this.fireError(formFile.getAbsolutePath() + ": " + "The form is bound to the class " + classToBind + ".\n" + "Another form " + alreadyProcessedForm.getAbsolutePath() + " is also bound to this class.");
                continue;
            }
            class2form.put(classToBind, formFile);
            try {
                int version;
                FileInputStream stream = new FileInputStream(classFile);
                try {
                    version = Javac2.getClassFileVersion(new ClassReader((InputStream)stream));
                }
                finally {
                    ((InputStream)stream).close();
                }
                AntNestedFormLoader formLoader = new AntNestedFormLoader(finder.getLoader(), this.myNestedFormPathList);
                InstrumenterClassWriter classWriter = new InstrumenterClassWriter(Javac2.getAsmClassWriterFlags(version), finder);
                AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, finder, formLoader, false, classWriter);
                codeGenerator.patchFile(classFile);
                FormErrorInfo[] warnings = codeGenerator.getWarnings();
                for (int j = 0; j < warnings.length; ++j) {
                    this.log(formFile.getAbsolutePath() + ": " + warnings[j].getErrorMessage(), 1);
                }
                FormErrorInfo[] errors = codeGenerator.getErrors();
                if (errors.length <= 0) continue;
                StringBuffer message = new StringBuffer();
                for (int j = 0; j < errors.length; ++j) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append(formFile.getAbsolutePath()).append(": ").append(errors[j].getErrorMessage());
                }
                this.fireError(message.toString());
                continue;
            }
            catch (Exception e) {
                this.fireError("Forms instrumentation failed for " + formFile.getAbsolutePath() + ": " + e.toString());
            }
        }
    }

    private static int getAsmClassWriterFlags(int version) {
        return version >= 50 && version != 196653 ? 2 : 1;
    }

    private InstrumentationClassFinder buildClasspathClassLoader() {
        boolean shouldInclude;
        StringBuffer classPathBuffer = new StringBuffer();
        Project project = this.getProject();
        Path cp = new Path(project);
        this.appendPath(cp, this.getBootclasspath());
        cp.setLocation(this.getDestdir().getAbsoluteFile());
        this.appendPath(cp, this.getClasspath());
        this.appendPath(cp, this.getSourcepath());
        this.appendPath(cp, this.getSrcdir());
        if (this.getIncludeantruntime()) {
            cp.addExisting(cp.concatSystemClasspath("last"));
        }
        if (!(shouldInclude = this.getIncludejavaruntime())) {
            String propValue;
            shouldInclude = project != null ? !"false".equalsIgnoreCase(propValue = project.getProperty(PROPERTY_INSTRUMENTATION_INCLUDE_JAVA_RUNTIME)) && !"no".equalsIgnoreCase(propValue) : true;
        }
        if (shouldInclude) {
            cp.addJavaRuntime();
        }
        cp.addExtdirs(this.getExtdirs());
        String[] pathElements = cp.list();
        for (int i = 0; i < pathElements.length; ++i) {
            String pathElement = pathElements[i];
            classPathBuffer.append(File.pathSeparator);
            classPathBuffer.append(pathElement);
        }
        String classPath = classPathBuffer.toString();
        this.log("classpath=" + classPath, 3);
        try {
            return Javac2.createInstrumentationClassFinder(classPath);
        }
        catch (MalformedURLException e) {
            this.fireError(e.getMessage());
            return null;
        }
    }

    private void appendPath(Path cp, Path p) {
        if (p != null && p.size() > 0) {
            cp.append(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int instrumentNotNull(File dir, InstrumentationClassFinder finder) {
        int instrumented = 0;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            if (name.endsWith(".class")) {
                String path = file.getPath();
                this.log("Adding @NotNull assertions to " + path, 3);
                try {
                    FileInputStream inputStream = new FileInputStream(file);
                    try {
                        InstrumenterClassWriter writer;
                        ClassReader reader = new ClassReader((InputStream)inputStream);
                        int version = Javac2.getClassFileVersion(reader);
                        if (version < 49 || !NotNullVerifyingInstrumenter.processClassFile(reader, (ClassVisitor)(writer = new InstrumenterClassWriter(Javac2.getAsmClassWriterFlags(version), finder)))) continue;
                        FileOutputStream fileOutputStream = new FileOutputStream(path);
                        try {
                            fileOutputStream.write(writer.toByteArray());
                            ++instrumented;
                        }
                        finally {
                            fileOutputStream.close();
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log("Failed to instrument @NotNull assertion for " + path + ": " + e.getMessage(), 1);
                }
                catch (Exception e) {
                    this.fireError("@NotNull instrumentation failed for " + path + ": " + e.toString());
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            instrumented += this.instrumentNotNull(file, finder);
        }
        return instrumented;
    }

    private static int getClassFileVersion(ClassReader reader) {
        final int[] classfileVersion = new int[1];
        reader.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                classfileVersion[0] = version;
            }
        }, 0);
        return classfileVersion[0];
    }

    private void fireError(String message) {
        if (this.failOnError) {
            throw new BuildException(message, this.getLocation());
        }
        this.log(message, 0);
    }

    private File getClassFile(String className) {
        String classOrInnerName = this.getClassOrInnerName(className);
        if (classOrInnerName == null) {
            return null;
        }
        return new File(this.getDestdir().getAbsolutePath(), classOrInnerName + ".class");
    }

    private String getClassOrInnerName(String className) {
        File classFile = new File(this.getDestdir().getAbsolutePath(), className + ".class");
        if (classFile.exists()) {
            return className;
        }
        int position = className.lastIndexOf(47);
        if (position == -1) {
            return null;
        }
        return this.getClassOrInnerName(className.substring(0, position) + '$' + className.substring(position + 1));
    }

    protected void resetFileLists() {
        super.resetFileLists();
        this.myFormFiles = new ArrayList();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        super.scanDir(srcDir, destDir, files);
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.endsWith(".form")) continue;
            this.log("Found form file " + file, 3);
            this.myFormFiles.add(new File(srcDir, file));
        }
    }

    private static InstrumentationClassFinder createInstrumentationClassFinder(String classPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            urls.add(new File(s).toURI().toURL());
        }
        URL[] urlsArr = urls.toArray(new URL[urls.size()]);
        return new InstrumentationClassFinder(urlsArr);
    }

    private class AntNestedFormLoader
    implements NestedFormLoader {
        private final ClassLoader myLoader;
        private final List myNestedFormPathList;
        private final HashMap myFormCache = new HashMap();

        public AntNestedFormLoader(ClassLoader loader, List nestedFormPathList) {
            this.myLoader = loader;
            this.myNestedFormPathList = nestedFormPathList;
        }

        public LwRootContainer loadForm(String formFilePath) throws Exception {
            InputStream resourceStream;
            if (this.myFormCache.containsKey(formFilePath)) {
                return (LwRootContainer)this.myFormCache.get(formFilePath);
            }
            String lowerFormFilePath = formFilePath.toLowerCase();
            Javac2.this.log("Searching for form " + lowerFormFilePath, 3);
            for (File file : Javac2.this.myFormFiles) {
                String name = file.getAbsolutePath().replace(File.separatorChar, '/').toLowerCase();
                Javac2.this.log("Comparing with " + name, 3);
                if (!name.endsWith(lowerFormFilePath)) continue;
                return this.loadForm(formFilePath, new FileInputStream(file));
            }
            if (this.myNestedFormPathList != null) {
                for (int i = 0; i < this.myNestedFormPathList.size(); ++i) {
                    PrefixedPath path = (PrefixedPath)((Object)this.myNestedFormPathList.get(i));
                    File formFile = path.findFile(formFilePath);
                    if (formFile == null) continue;
                    return this.loadForm(formFilePath, new FileInputStream(formFile));
                }
            }
            if ((resourceStream = this.myLoader.getResourceAsStream(formFilePath)) != null) {
                return this.loadForm(formFilePath, resourceStream);
            }
            throw new Exception("Cannot find nested form file " + formFilePath);
        }

        private LwRootContainer loadForm(String formFileName, InputStream resourceStream) throws Exception {
            LwRootContainer container = Utils.getRootContainer(resourceStream, null);
            this.myFormCache.put(formFileName, container);
            return container;
        }

        public String getClassToBindName(LwRootContainer container) {
            String className = container.getClassToBind();
            String result = Javac2.this.getClassOrInnerName(className.replace('.', '/'));
            if (result != null) {
                return result.replace('/', '.');
            }
            return className;
        }
    }
}

