/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.JavaCvsSrcBundle;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.InvalidEntryFormatException;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class Entries {
    private final Map<String, Entry> fileNameToEntryMap = new HashMap<String, Entry>();
    @NonNls
    private static final String DIRECTORY_PREFIX = "D";

    public void addEntry(Entry entry) {
        BugLog.getInstance().assertNotNull(entry);
        BugLog.getInstance().assertNotNull(entry.getFileName());
        this.fileNameToEntryMap.put(entry.getFileName(), entry);
    }

    public boolean removeEntry(String fileName) {
        BugLog.getInstance().assertNotNull(fileName);
        return this.fileNameToEntryMap.remove(fileName) != null;
    }

    public Entry getEntry(String fileName) {
        return this.fileNameToEntryMap.get(fileName);
    }

    public Collection<Entry> getEntries() {
        return Collections.unmodifiableCollection(this.fileNameToEntryMap.values());
    }

    public void getEntries(Collection<Entry> collection) {
        collection.addAll(this.fileNameToEntryMap.values());
    }

    public int size() {
        return this.fileNameToEntryMap.size();
    }

    public void read(File entriesFile, String charsetName) throws IOException {
        try {
            this.read(new InputStreamReader((InputStream)new FileInputStream(entriesFile), charsetName));
        }
        catch (InvalidEntryFormatException ex) {
            ex.setEntriesFile(entriesFile);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader) throws IOException {
        BufferedReader lineReader = new BufferedReader(reader);
        try {
            String line = lineReader.readLine();
            while (line != null) {
                if (!(line.trim().length() == 0 || line.startsWith(DIRECTORY_PREFIX) && line.trim().length() == 1)) {
                    this.addEntry(Entry.createEntryForLine(line));
                }
                line = lineReader.readLine();
            }
        }
        finally {
            lineReader.close();
        }
    }

    public void write(File entriesFile, String lineSeparator, String charsetName) throws IOException {
        File tempFile = new File(entriesFile.getAbsolutePath() + "~");
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, charsetName);
        this.write(writer, lineSeparator);
        if (entriesFile.exists() && !entriesFile.delete()) {
            throw new IOException(JavaCvsSrcBundle.message("could.not.delete.file.error.message", entriesFile.getAbsolutePath()));
        }
        FileUtil.rename((File)tempFile, (File)entriesFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer, String lineSeparator) throws IOException {
        writer = new BufferedWriter(writer);
        try {
            if (this.fileNameToEntryMap.size() == 0) {
                writer.write(DIRECTORY_PREFIX);
                writer.write(lineSeparator);
            } else {
                Entry[] entryArray = new Entry[this.fileNameToEntryMap.size()];
                this.fileNameToEntryMap.values().toArray(entryArray);
                Arrays.sort(entryArray, new EntriesComparator());
                for (Entry entry : entryArray) {
                    writer.write(entry.toString());
                    writer.write(lineSeparator);
                }
            }
        }
        finally {
            writer.close();
        }
    }

    private static final class EntriesComparator
    implements Comparator<Entry> {
        private EntriesComparator() {
        }

        @Override
        public int compare(Entry entry1, Entry entry2) {
            if (entry1.isDirectory() != entry2.isDirectory()) {
                if (entry1.isDirectory()) {
                    return -1;
                }
                return 1;
            }
            return entry1.getFileName().compareTo(entry2.getFileName());
        }
    }
}

