/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.StripedLockIntObjectConcurrentHashMap;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.rpc.AsyncResultCallback;

public final class MessageManager<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS, ERROR_DETAILS> {
    public static final Logger LOG = Logger.getInstance(MessageManager.class);
    private final ConcurrentIntObjectMap<AsyncResultCallback<SUCCESS, ERROR_DETAILS>> callbackMap = new StripedLockIntObjectConcurrentHashMap();
    private final Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS, ERROR_DETAILS> handler;
    private volatile boolean closed;

    public MessageManager(Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS, ERROR_DETAILS> handler) {
        this.handler = handler;
    }

    public void send(@NotNull OUTGOING message, @NotNull AsyncResultCallback<SUCCESS, ERROR_DETAILS> callback) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/rpc/MessageManager", "send"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/rpc/MessageManager", "send"));
        }
        if (this.closed) {
            callback.onError("Connection is closed", null);
            return;
        }
        int sequence = this.handler.getUpdatedSequence(message);
        this.callbackMap.put(sequence, callback);
        this.doSend(message, sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(@NotNull OUTGOING message, int sequence) {
        boolean success;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/rpc/MessageManager", "doSend"));
        }
        try {
            success = this.handler.write(message);
        }
        catch (Throwable e) {
            try {
                this.failedToSend(sequence);
            }
            finally {
                LOG.error("Failed to send", e);
            }
            return;
        }
        if (!success) {
            this.failedToSend(sequence);
        }
    }

    private void failedToSend(int sequence) {
        AsyncResultCallback callback = (AsyncResultCallback)this.callbackMap.remove(sequence);
        if (callback != null) {
            callback.onError("Failed to send", null);
        }
    }

    public void processIncoming(INCOMING incomingParsed) {
        INCOMING_WITH_SEQ commandResponse = this.handler.readIfHasSequence(incomingParsed);
        if (commandResponse == null) {
            if (this.closed) {
                LOG.info("Connection closed, ignore incoming");
            } else {
                this.handler.acceptNonSequence(incomingParsed);
            }
            return;
        }
        AsyncResultCallback<SUCCESS, Object> callback = this.getCallbackAndRemove(this.handler.getSequence(commandResponse));
        try {
            if (this.closed) {
                callback.onError("Connection closed", null);
            } else {
                this.handler.call(commandResponse, callback);
            }
        }
        catch (Throwable e) {
            callback.onError("Failed to dispatch response to callback", null);
            LOG.error("Failed to dispatch response to callback", e);
        }
    }

    public AsyncResultCallback<SUCCESS, ERROR_DETAILS> getCallbackAndRemove(int id) {
        AsyncResultCallback callback = (AsyncResultCallback)this.callbackMap.remove(id);
        if (callback == null) {
            throw new IllegalArgumentException("Cannot find callback with id " + id);
        }
        return callback;
    }

    public void closed() {
        this.closed = true;
    }

    public void cancelWaitingRequests() {
        ConcurrentIntObjectMap<AsyncResultCallback<SUCCESS, ERROR_DETAILS>> map = this.callbackMap;
        int[] keys = map.keys();
        Arrays.sort(keys);
        for (int key : keys) {
            try {
                ((AsyncResultCallback)map.get(key)).onError("Connection closed", null);
            }
            catch (Throwable e) {
                LOG.error("Failed to reject callback on connection closed", e);
            }
        }
    }

    public static interface Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS, ERROR_DETAILS> {
        public int getUpdatedSequence(OUTGOING var1);

        public boolean write(@NotNull OUTGOING var1) throws IOException;

        public INCOMING_WITH_SEQ readIfHasSequence(INCOMING var1);

        public int getSequence(INCOMING_WITH_SEQ var1);

        public void acceptNonSequence(INCOMING var1);

        public void call(INCOMING_WITH_SEQ var1, AsyncResultCallback<SUCCESS, ERROR_DETAILS> var2);
    }
}

