/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class ClassReferenceParser
extends StandardHeaderParser {
    public static final HeaderParser INSTANCE = new ClassReferenceParser();

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        if (headerValuePart == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "getReferences"));
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)headerValuePart);
        JavaClassReferenceProvider provider = module != null ? new JavaClassReferenceProvider(){

            @Override
            public GlobalSearchScope getScope(Project project) {
                return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            }
        } : new JavaClassReferenceProvider();
        PsiReference[] psiReferenceArray = provider.getReferencesByElement(headerValuePart);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "annotate"));
        }
        HeaderValue value = header.getHeaderValue();
        if (!(value instanceof HeaderValuePart)) {
            return false;
        }
        PsiReference[] references = value.getReferences();
        if (references.length == 0) {
            holder.createErrorAnnotation(((HeaderValuePart)value).getHighlightingRange(), ManifestBundle.message("header.reference.invalid", new Object[0]));
            return true;
        }
        for (int i = 0; i < references.length; ++i) {
            PsiReference reference = references[i];
            PsiElement element = reference.resolve();
            if (element == null) {
                TextRange range = reference.getRangeInElement().shiftRight(value.getTextOffset());
                holder.createErrorAnnotation(range, ManifestBundle.message("header.reference.unknown", new Object[0]));
                return true;
            }
            if (i != references.length - 1 || !this.checkClass(reference, element, holder)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkClass(@NotNull PsiReference reference, @NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "checkClass"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "checkClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser", "checkClass"));
        }
        if (element instanceof PsiClass && PsiMethodUtil.hasMainMethod((PsiClass)((PsiClass)element))) {
            return false;
        }
        TextRange range = reference.getRangeInElement().shiftRight(reference.getElement().getTextOffset());
        holder.createErrorAnnotation(range, ManifestBundle.message("header.main.class.invalid", new Object[0]));
        return true;
    }
}

