/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.runConfigurations;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.hash.HashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationPropertiesSerializer;

public class JpsRunConfigurationSerializer {
    public static void loadRunConfigurations(@NotNull JpsProject project, @Nullable Element runManagerTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/serialization/runConfigurations/JpsRunConfigurationSerializer", "loadRunConfigurations"));
        }
        HashMap serializers = new HashMap();
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsRunConfigurationPropertiesSerializer<?> jpsRunConfigurationPropertiesSerializer : extension.getRunConfigurationPropertiesSerializers()) {
                serializers.put(jpsRunConfigurationPropertiesSerializer.getTypeId(), jpsRunConfigurationPropertiesSerializer);
            }
        }
        for (Element configurationTag : JDOMUtil.getChildren((Element)runManagerTag, (String)"configuration")) {
            String typeId;
            JpsRunConfigurationPropertiesSerializer jpsRunConfigurationPropertiesSerializer;
            if (Boolean.parseBoolean(configurationTag.getAttributeValue("default")) || (jpsRunConfigurationPropertiesSerializer = (JpsRunConfigurationPropertiesSerializer)serializers.get(typeId = configurationTag.getAttributeValue("type"))) == null) continue;
            JpsRunConfigurationSerializer.loadRunConfiguration(configurationTag, jpsRunConfigurationPropertiesSerializer, project);
        }
    }

    private static <P extends JpsElement> void loadRunConfiguration(Element configurationTag, JpsRunConfigurationPropertiesSerializer<P> serializer, JpsProject project) {
        P properties = serializer.loadProperties(configurationTag);
        project.addRunConfiguration(configurationTag.getAttributeValue("name"), (JpsRunConfigurationType)serializer.getType(), properties);
    }
}

