/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";

    @Nullable
    public static String getModuleDir(String moduleFilePath) {
        File moduleDirFile = new File(moduleFilePath).getParentFile();
        if (moduleDirFile == null) {
            return null;
        }
        File moduleDirParent = moduleDirFile.getParentFile();
        if (moduleDirParent != null && moduleDirFile.getName().equals(DIRECTORY_STORE_NAME)) {
            moduleDirFile = moduleDirParent;
        }
        String moduleDir = moduleDirFile.getPath();
        if ((moduleDir = moduleDir.replace(File.separatorChar, '/')).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    public static String getUserHomePath() {
        return StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()), (String)"/");
    }

    public static Map<String, String> getGlobalSystemMacros() {
        HashMap map = new HashMap();
        map.put(APPLICATION_HOME_DIR, PathMacroUtil.getApplicationHomeDirPath());
        map.put(APPLICATION_PLUGINS_DIR, PathMacroUtil.getApplicationPluginsDirPath());
        map.put(USER_HOME_NAME, PathMacroUtil.getUserHomePath());
        return map;
    }

    private static String getApplicationHomeDirPath() {
        return FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
    }

    private static String getApplicationPluginsDirPath() {
        return FileUtil.toSystemIndependentName((String)PathManager.getPluginsPath());
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name) {
        if (APPLICATION_HOME_DIR.equals(name)) {
            return PathMacroUtil.getApplicationHomeDirPath();
        }
        if (APPLICATION_PLUGINS_DIR.equals(name)) {
            return PathMacroUtil.getApplicationPluginsDirPath();
        }
        if (USER_HOME_NAME.equals(name)) {
            return PathMacroUtil.getUserHomePath();
        }
        return null;
    }
}

