/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryPropertiesSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationPropertiesSerializer;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JpsModelSerializerExtension {
    public static Iterable<JpsModelSerializerExtension> getExtensions() {
        return JpsServiceManager.getInstance().getExtensions(JpsModelSerializerExtension.class);
    }

    public void loadRootModel(@NotNull JpsModule module, @NotNull Element rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "loadRootModel"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "loadRootModel"));
        }
    }

    public void saveRootModel(@NotNull JpsModule module, @NotNull Element rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "saveRootModel"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "saveRootModel"));
        }
    }

    public void loadModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "loadModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "loadModuleOptions"));
        }
    }

    public void saveModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "saveModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "saveModuleOptions"));
        }
    }

    public List<JpsLibraryRootTypeSerializer> getLibraryRootTypeSerializers() {
        return Collections.emptyList();
    }

    @NotNull
    public List<JpsLibraryRootTypeSerializer> getSdkRootTypeSerializers() {
        List<JpsLibraryRootTypeSerializer> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getSdkRootTypeSerializers"));
        }
        return list;
    }

    public void loadModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
    }

    public void saveModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
    }

    @Nullable
    public JpsElementReference<? extends JpsCompositeElement> createLibraryTableReference(String tableLevel) {
        return null;
    }

    @Nullable
    public String getLibraryTableLevelId(JpsElementReference<? extends JpsCompositeElement> reference) {
        return null;
    }

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getProjectExtensionSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsGlobalExtensionSerializer> getGlobalExtensionSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getGlobalExtensionSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsModulePropertiesSerializer<?>> getModulePropertiesSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getModulePropertiesSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsModuleSourceRootPropertiesSerializer<?>> getModuleSourceRootPropertiesSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getModuleSourceRootPropertiesSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsLibraryPropertiesSerializer<?>> getLibraryPropertiesSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getLibraryPropertiesSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getSdkPropertiesSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getFacetConfigurationSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getPackagingElementSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsArtifactPropertiesSerializer<?>> getArtifactTypePropertiesSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getArtifactTypePropertiesSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsArtifactExtensionSerializer<?>> getArtifactExtensionSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getArtifactExtensionSerializers"));
        }
        return list;
    }

    @Nullable
    public JpsModuleClasspathSerializer getClasspathSerializer() {
        return null;
    }

    @NotNull
    public List<? extends JpsRunConfigurationPropertiesSerializer<?>> getRunConfigurationPropertiesSerializers() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsModelSerializerExtension", "getRunConfigurationPropertiesSerializers"));
        }
        return list;
    }
}

