/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;

public abstract class JpsElementExtensionSerializerBase<E extends JpsElement> {
    private final String myConfigFileName;
    private final String myComponentName;

    protected JpsElementExtensionSerializerBase(@Nullable String configFileName, @NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/serialization/JpsElementExtensionSerializerBase", "<init>"));
        }
        this.myComponentName = componentName;
        this.myConfigFileName = configFileName;
    }

    @Nullable
    public String getConfigFileName() {
        return this.myConfigFileName;
    }

    @NotNull
    public String getComponentName() {
        String string = this.myComponentName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/JpsElementExtensionSerializerBase", "getComponentName"));
        }
        return string;
    }

    public abstract void loadExtension(@NotNull E var1, @NotNull Element var2);

    public void loadExtensionWithDefaultSettings(@NotNull E e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/serialization/JpsElementExtensionSerializerBase", "loadExtensionWithDefaultSettings"));
        }
    }

    public abstract void saveExtension(@NotNull E var1, @NotNull Element var2);
}

