/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.module.impl.JpsDependencyElementBase;

public class JpsSdkDependencyImpl
extends JpsDependencyElementBase<JpsSdkDependencyImpl>
implements JpsSdkDependency {
    private final JpsSdkType<?> mySdkType;

    public JpsSdkDependencyImpl(@NotNull JpsSdkType<?> sdkType) {
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/module/impl/JpsSdkDependencyImpl", "<init>"));
        }
        this.mySdkType = sdkType;
    }

    public JpsSdkDependencyImpl(JpsSdkDependencyImpl original) {
        super(original);
        this.mySdkType = original.mySdkType;
    }

    @NotNull
    public JpsSdkDependencyImpl createCopy() {
        JpsSdkDependencyImpl jpsSdkDependencyImpl = new JpsSdkDependencyImpl(this);
        if (jpsSdkDependencyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsSdkDependencyImpl", "createCopy"));
        }
        return jpsSdkDependencyImpl;
    }

    @NotNull
    public JpsSdkType<?> getSdkType() {
        JpsSdkType<?> jpsSdkType = this.mySdkType;
        if (jpsSdkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsSdkDependencyImpl", "getSdkType"));
        }
        return jpsSdkType;
    }

    public JpsLibrary resolveSdk() {
        JpsSdkReference<?> reference = this.getSdkReference();
        if (reference == null) {
            return null;
        }
        return (JpsLibrary)reference.resolve();
    }

    @Nullable
    public JpsSdkReference<?> getSdkReference() {
        return this.getContainingModule().getSdkReference(this.mySdkType);
    }

    public boolean isInherited() {
        return false;
    }

    public String toString() {
        return "sdk dep [" + this.mySdkType + "]";
    }
}

