/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsFileTypesConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsFileTypesConfigurationImpl;
import org.jetbrains.jps.model.impl.JpsGlobalElementReference;
import org.jetbrains.jps.model.impl.JpsRootElementBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;

public class JpsGlobalImpl
extends JpsRootElementBase<JpsGlobalImpl>
implements JpsGlobal {
    private final JpsLibraryCollectionImpl myLibraryCollection;

    public JpsGlobalImpl(@NotNull JpsModel model, JpsEventDispatcher eventDispatcher) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "<init>"));
        }
        super(model, eventDispatcher);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
        this.myContainer.setChild(JpsFileTypesConfigurationImpl.ROLE, (JpsElement)new JpsFileTypesConfigurationImpl());
    }

    public JpsGlobalImpl(JpsGlobalImpl original, JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(original, model, eventDispatcher);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @NotNull
    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(@NotNull LibraryType libraryType, @NotNull String name) {
        if (libraryType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addLibrary"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addLibrary"));
        }
        JpsLibrary jpsLibrary = this.myLibraryCollection.addLibrary(name, libraryType);
        if (jpsLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addLibrary"));
        }
        return jpsLibrary;
    }

    public <P extends JpsElement> JpsTypedLibrary<JpsSdk<P>> addSdk(@NotNull String name, @Nullable String homePath, @Nullable String versionString, @NotNull JpsSdkType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addSdk"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addSdk"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addSdk"));
        }
        JpsTypedLibrary sdk = JpsElementFactory.getInstance().createSdk(name, homePath, versionString, type, properties);
        this.myLibraryCollection.addLibrary((JpsLibrary)sdk);
        return sdk;
    }

    public <P extends JpsElement, SdkType extends JpsSdkType<P>> JpsTypedLibrary<JpsSdk<P>> addSdk(@NotNull String name, @Nullable String homePath, @Nullable String versionString, @NotNull SdkType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addSdk"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "addSdk"));
        }
        return this.addSdk(name, homePath, versionString, type, (JpsElement)((JpsElementTypeWithDefaultProperties)type).createDefaultProperties());
    }

    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        JpsLibraryCollectionImpl jpsLibraryCollectionImpl = this.myLibraryCollection;
        if (jpsLibraryCollectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "getLibraryCollection"));
        }
        return jpsLibraryCollectionImpl;
    }

    @NotNull
    public JpsFileTypesConfiguration getFileTypesConfiguration() {
        JpsFileTypesConfiguration jpsFileTypesConfiguration = (JpsFileTypesConfiguration)this.myContainer.getChild(JpsFileTypesConfigurationImpl.ROLE);
        if (jpsFileTypesConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "getFileTypesConfiguration"));
        }
        return jpsFileTypesConfiguration;
    }

    @NotNull
    public JpsElementReference<JpsGlobal> createReference() {
        JpsGlobalElementReference jpsGlobalElementReference = new JpsGlobalElementReference();
        if (jpsGlobalElementReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsGlobalImpl", "createReference"));
        }
        return jpsGlobalElementReference;
    }
}

