/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsEventDispatcher;

public abstract class JpsEventDispatcherBase
implements JpsEventDispatcher {
    private final Map<Class<?>, EventDispatcher<?>> myDispatchers = new HashMap();

    @NotNull
    public <T extends EventListener> T getPublisher(Class<T> listenerClass) {
        EventDispatcher dispatcher = this.myDispatchers.get(listenerClass);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(listenerClass);
            this.myDispatchers.put(listenerClass, dispatcher);
        }
        EventListener eventListener = dispatcher.getMulticaster();
        if (eventListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsEventDispatcherBase", "getPublisher"));
        }
        return (T)eventListener;
    }

    public <T extends JpsElement> void fireElementAdded(@NotNull T element, @NotNull JpsElementChildRole<T> role) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsEventDispatcherBase", "fireElementAdded"));
        }
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsEventDispatcherBase", "fireElementAdded"));
        }
        role.fireElementAdded((JpsEventDispatcher)this, element);
    }

    public <T extends JpsElement> void fireElementRemoved(@NotNull T element, @NotNull JpsElementChildRole<T> role) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsEventDispatcherBase", "fireElementRemoved"));
        }
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsEventDispatcherBase", "fireElementRemoved"));
        }
        role.fireElementRemoved((JpsEventDispatcher)this, element);
    }
}

