/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.impl.JpsEncodingProjectConfigurationImpl;

public class JpsEncodingConfigurationServiceImpl
extends JpsEncodingConfigurationService {
    private static final JpsElementChildRoleBase<JpsSimpleElement<String>> ENCODING_ROLE = JpsElementChildRoleBase.create((String)"encoding");

    @Nullable
    public String getGlobalEncoding(@NotNull JpsGlobal global) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "getGlobalEncoding"));
        }
        JpsSimpleElement encoding = (JpsSimpleElement)global.getContainer().getChild(ENCODING_ROLE);
        return encoding != null ? (String)encoding.getData() : null;
    }

    public void setGlobalEncoding(@NotNull JpsGlobal global, @Nullable String encoding) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setGlobalEncoding"));
        }
        if (encoding != null) {
            global.getContainer().setChild(ENCODING_ROLE, (JpsElement)JpsElementFactory.getInstance().createSimpleElement((Object)encoding));
        } else {
            global.getContainer().removeChild(ENCODING_ROLE);
        }
    }

    @Nullable
    public String getProjectEncoding(@NotNull JpsModel model) {
        String projectEncoding;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "getProjectEncoding"));
        }
        JpsEncodingProjectConfiguration configuration = this.getEncodingConfiguration(model.getProject());
        if (configuration != null && (projectEncoding = configuration.getProjectEncoding()) != null) {
            return projectEncoding;
        }
        return this.getGlobalEncoding(model.getGlobal());
    }

    @Nullable
    public JpsEncodingProjectConfiguration getEncodingConfiguration(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "getEncodingConfiguration"));
        }
        return (JpsEncodingProjectConfiguration)project.getContainer().getChild(JpsEncodingProjectConfigurationImpl.ROLE);
    }

    @NotNull
    public JpsEncodingProjectConfiguration setEncodingConfiguration(@NotNull JpsProject project, @Nullable String projectEncoding, @NotNull Map<String, String> urlToEncoding) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setEncodingConfiguration"));
        }
        if (urlToEncoding == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setEncodingConfiguration"));
        }
        JpsEncodingProjectConfigurationImpl configuration = new JpsEncodingProjectConfigurationImpl(urlToEncoding, projectEncoding);
        JpsEncodingProjectConfiguration jpsEncodingProjectConfiguration = (JpsEncodingProjectConfiguration)project.getContainer().setChild(JpsEncodingProjectConfigurationImpl.ROLE, (JpsElement)configuration);
        if (jpsEncodingProjectConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setEncodingConfiguration"));
        }
        return jpsEncodingProjectConfiguration;
    }
}

