/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.impl.JpsDummyElementImpl;
import org.jetbrains.jps.model.impl.JpsEventDispatcherBase;
import org.jetbrains.jps.model.impl.JpsGlobalElementReference;
import org.jetbrains.jps.model.impl.JpsModelImpl;
import org.jetbrains.jps.model.impl.JpsProjectElementReference;
import org.jetbrains.jps.model.impl.JpsSimpleElementImpl;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryReferenceImpl;
import org.jetbrains.jps.model.library.impl.JpsSdkReferenceImpl;
import org.jetbrains.jps.model.library.impl.sdk.JpsSdkImpl;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.impl.JpsModuleImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleReferenceImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootImpl;

public class JpsElementFactoryImpl
extends JpsElementFactory {
    public JpsModel createModel() {
        return new JpsModelImpl(new JpsEventDispatcherBase(){

            public void fireElementRenamed(@NotNull JpsNamedElement element, @NotNull String oldName, @NotNull String newName) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl$1", "fireElementRenamed"));
                }
                if (oldName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl$1", "fireElementRenamed"));
                }
                if (newName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl$1", "fireElementRenamed"));
                }
            }

            public void fireElementChanged(@NotNull JpsElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl$1", "fireElementChanged"));
                }
            }
        });
    }

    public <P extends JpsElement> JpsModule createModule(@NotNull String name, @NotNull JpsModuleType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModule"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModule"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModule"));
        }
        return new JpsModuleImpl<P>(type, name, properties);
    }

    public <P extends JpsElement> JpsTypedLibrary<P> createLibrary(@NotNull String name, @NotNull JpsLibraryType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createLibrary"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createLibrary"));
        }
        return new JpsLibraryImpl<P>(name, type, properties);
    }

    public <P extends JpsElement> JpsTypedLibrary<JpsSdk<P>> createSdk(@NotNull String name, @Nullable String homePath, @Nullable String versionString, @NotNull JpsSdkType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSdk"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSdk"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSdk"));
        }
        return this.createLibrary(name, (JpsLibraryType<P>)type, (P)new JpsSdkImpl<P>(homePath, versionString, type, properties));
    }

    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot createModuleSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModuleSourceRoot"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModuleSourceRoot"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModuleSourceRoot"));
        }
        JpsModuleSourceRootImpl<P> jpsModuleSourceRootImpl = new JpsModuleSourceRootImpl<P>(url, type, properties);
        if (jpsModuleSourceRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModuleSourceRoot"));
        }
        return jpsModuleSourceRootImpl;
    }

    @NotNull
    public JpsModuleReference createModuleReference(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModuleReference"));
        }
        JpsModuleReferenceImpl jpsModuleReferenceImpl = new JpsModuleReferenceImpl(moduleName);
        if (jpsModuleReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createModuleReference"));
        }
        return jpsModuleReferenceImpl;
    }

    @NotNull
    public JpsLibraryReference createLibraryReference(@NotNull String libraryName, @NotNull JpsElementReference<? extends JpsCompositeElement> parentReference) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createLibraryReference"));
        }
        if (parentReference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createLibraryReference"));
        }
        JpsLibraryReferenceImpl jpsLibraryReferenceImpl = new JpsLibraryReferenceImpl(libraryName, parentReference);
        if (jpsLibraryReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createLibraryReference"));
        }
        return jpsLibraryReferenceImpl;
    }

    @NotNull
    public <P extends JpsElement> JpsSdkReference<P> createSdkReference(@NotNull String sdkName, @NotNull JpsSdkType<P> sdkType) {
        if (sdkName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSdkReference"));
        }
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSdkReference"));
        }
        JpsSdkReferenceImpl<P> jpsSdkReferenceImpl = new JpsSdkReferenceImpl<P>(sdkName, sdkType, this.createGlobalReference());
        if (jpsSdkReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSdkReference"));
        }
        return jpsSdkReferenceImpl;
    }

    @NotNull
    public JpsElementReference<JpsProject> createProjectReference() {
        JpsProjectElementReference jpsProjectElementReference = new JpsProjectElementReference();
        if (jpsProjectElementReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createProjectReference"));
        }
        return jpsProjectElementReference;
    }

    @NotNull
    public JpsElementReference<JpsGlobal> createGlobalReference() {
        JpsGlobalElementReference jpsGlobalElementReference = new JpsGlobalElementReference();
        if (jpsGlobalElementReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createGlobalReference"));
        }
        return jpsGlobalElementReference;
    }

    @NotNull
    public JpsDummyElement createDummyElement() {
        JpsDummyElementImpl jpsDummyElementImpl = new JpsDummyElementImpl();
        if (jpsDummyElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createDummyElement"));
        }
        return jpsDummyElementImpl;
    }

    @NotNull
    public <D> JpsSimpleElement<D> createSimpleElement(@NotNull D data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSimpleElement"));
        }
        JpsSimpleElementImpl<D> jpsSimpleElementImpl = new JpsSimpleElementImpl<D>(data);
        if (jpsSimpleElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsElementFactoryImpl", "createSimpleElement"));
        }
        return jpsSimpleElementImpl;
    }
}

