/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints.properties;

import com.intellij.debugger.InstanceFilter;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import org.jetbrains.annotations.Nullable;

public class JavaBreakpointProperties<T extends JavaBreakpointProperties>
extends XBreakpointProperties<T> {
    @OptionTag(value="count-filter-enabled")
    public boolean COUNT_FILTER_ENABLED = false;
    @OptionTag(value="count-filter")
    public int COUNT_FILTER = 0;
    @OptionTag(value="class-filters-enabled")
    public boolean CLASS_FILTERS_ENABLED = false;
    private ClassFilter[] myClassFilters;
    private ClassFilter[] myClassExclusionFilters;
    @OptionTag(value="instance-filters-enabled")
    public boolean INSTANCE_FILTERS_ENABLED = false;
    private InstanceFilter[] myInstanceFilters;

    @Tag(value="instance-filters")
    @AbstractCollection(surroundWithTag=false)
    public InstanceFilter[] getInstanceFilters() {
        return this.myInstanceFilters != null ? this.myInstanceFilters : InstanceFilter.EMPTY_ARRAY;
    }

    public void setInstanceFilters(InstanceFilter[] instanceFilters) {
        this.myInstanceFilters = instanceFilters;
    }

    public void addInstanceFilter(long l) {
        InstanceFilter[] filters = new InstanceFilter[this.myInstanceFilters.length + 1];
        System.arraycopy(this.myInstanceFilters, 0, filters, 0, this.myInstanceFilters.length);
        filters[this.myInstanceFilters.length] = InstanceFilter.create(String.valueOf(l));
        this.myInstanceFilters = filters;
    }

    @Tag(value="class-filters")
    @AbstractCollection(surroundWithTag=false)
    public final ClassFilter[] getClassFilters() {
        return this.myClassFilters != null ? this.myClassFilters : ClassFilter.EMPTY_ARRAY;
    }

    public final void setClassFilters(ClassFilter[] classFilters) {
        this.myClassFilters = classFilters;
    }

    @Tag(value="class-exclusion-filters")
    @AbstractCollection(surroundWithTag=false)
    public ClassFilter[] getClassExclusionFilters() {
        return this.myClassExclusionFilters != null ? this.myClassExclusionFilters : ClassFilter.EMPTY_ARRAY;
    }

    public void setClassExclusionFilters(ClassFilter[] classExclusionFilters) {
        this.myClassExclusionFilters = classExclusionFilters;
    }

    @Nullable
    public T getState() {
        return (T)((Object)this);
    }

    public void loadState(T state) {
        this.COUNT_FILTER_ENABLED = ((JavaBreakpointProperties)((Object)state)).COUNT_FILTER_ENABLED;
        this.COUNT_FILTER = ((JavaBreakpointProperties)((Object)state)).COUNT_FILTER;
        this.CLASS_FILTERS_ENABLED = ((JavaBreakpointProperties)((Object)state)).CLASS_FILTERS_ENABLED;
        this.myClassFilters = ((JavaBreakpointProperties)((Object)state)).getClassFilters();
        this.myClassExclusionFilters = ((JavaBreakpointProperties)((Object)state)).getClassExclusionFilters();
        this.INSTANCE_FILTERS_ENABLED = ((JavaBreakpointProperties)((Object)state)).INSTANCE_FILTERS_ENABLED;
        this.myInstanceFilters = ((JavaBreakpointProperties)((Object)state)).getInstanceFilters();
    }
}

