/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints;

import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaBreakpointAdapterBase
extends XBreakpointAdapter<XLineBreakpoint<XBreakpointProperties>> {
    protected final Project myProject;

    public JavaBreakpointAdapterBase(Project project) {
        this.myProject = project;
    }

    @Nullable
    public LineBreakpoint createBreakpoint(XLineBreakpoint<XBreakpointProperties> breakpoint) {
        Document document;
        String url = breakpoint.getFileUrl();
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        Document document2 = document = file != null ? FileDocumentManager.getInstance().getDocument(file) : null;
        if (document == null) {
            return null;
        }
        LineBreakpoint jBreakpoint = this.createInvisibleBreakpoint(this.myProject, document, breakpoint);
        this.configureCreatedBreakpoint(jBreakpoint, breakpoint);
        return jBreakpoint;
    }

    protected void configureCreatedBreakpoint(LineBreakpoint oldBreakpoint, XLineBreakpoint<XBreakpointProperties> breakpoint) {
        RangeHighlighter highlighter = oldBreakpoint.getHighlighter();
        if (highlighter != null) {
            highlighter.dispose();
        }
    }

    public final void breakpointChanged(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/java/debugger/breakpoints/JavaBreakpointAdapterBase", "breakpointChanged"));
        }
        LineBreakpoint jBreakpoint = this.findBreakpoint(breakpoint);
        if (jBreakpoint != null) {
            this.updateBreakpoint(jBreakpoint, breakpoint);
        }
    }

    protected abstract void updateBreakpoint(LineBreakpoint var1, XLineBreakpoint<XBreakpointProperties> var2);

    protected abstract LineBreakpoint findBreakpoint(XLineBreakpoint<XBreakpointProperties> var1);

    protected LineBreakpoint createInvisibleBreakpoint(Project project, Document document, XLineBreakpoint<XBreakpointProperties> breakpoint) {
        LineBreakpoint oldBreakpoint = this.doCreateInstance(project, document, breakpoint);
        oldBreakpoint.setVisible(false);
        oldBreakpoint.updateUI();
        oldBreakpoint.setEnabled(breakpoint.isEnabled());
        return oldBreakpoint;
    }

    protected LineBreakpoint doCreateInstance(Project project, Document document, XLineBreakpoint<XBreakpointProperties> xBreakpoint) {
        return LineBreakpoint.create(project, xBreakpoint);
    }
}

