/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.breakpoints.ui.XDebuggerComboBoxProvider;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase
implements XDebuggerComboBoxProvider {
    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getFileType"));
        }
        return javaFileType;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        return JavaCodeFragmentFactory.getInstance((Project)project).createExpressionCodeFragment(text, context, null, isPhysical);
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<?>> createConditionComboBoxPanel(Project project, XDebuggerEditorsProvider debuggerEditorsProvider, String historyId, XSourcePosition sourcePosition) {
        return new ExpressionComboBoxPanel(project, historyId, sourcePosition){

            public void saveTo(@NotNull XBreakpoint<?> breakpoint) {
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider$1", "saveTo"));
                }
                TextWithImports text = this.myComboBox.getText();
                String condition = !text.getText().isEmpty() ? text.toExternalForm() : null;
                breakpoint.setCondition(condition);
                if (condition != null) {
                    this.myComboBox.addRecent(text);
                }
            }

            public void loadFrom(@NotNull XBreakpoint<?> breakpoint) {
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider$1", "loadFrom"));
                }
                this.myComboBox.setText(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, StringUtil.notNullize((String)breakpoint.getCondition())));
            }
        };
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<?>> createLogExpressionComboBoxPanel(Project project, XDebuggerEditorsProvider debuggerEditorsProvider, String historyId, XSourcePosition sourcePosition) {
        return new ExpressionComboBoxPanel(project, historyId, sourcePosition){

            public void saveTo(@NotNull XBreakpoint<?> breakpoint) {
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider$2", "saveTo"));
                }
                TextWithImports text = this.myComboBox.getText();
                breakpoint.setLogExpression(this.myComboBox.isEnabled() && !text.getText().isEmpty() ? text.toExternalForm() : null);
                if (text != null) {
                    this.myComboBox.addRecent(text);
                }
            }

            public void loadFrom(@NotNull XBreakpoint<?> breakpoint) {
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider$2", "loadFrom"));
                }
                this.myComboBox.setText(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, StringUtil.notNullize((String)breakpoint.getLogExpression())));
            }
        };
    }

    private abstract class ExpressionComboBoxPanel
    extends XBreakpointCustomPropertiesPanel<XBreakpoint<?>> {
        protected final DebuggerExpressionComboBox myComboBox;

        private ExpressionComboBoxPanel(Project project, String historyId, XSourcePosition sourcePosition) {
            this.myComboBox = new DebuggerExpressionComboBox(project, historyId);
            if (sourcePosition != null) {
                PsiElement element = JavaDebuggerEditorsProvider.this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
                this.myComboBox.setContext(element);
            } else {
                this.myComboBox.setContext(null);
            }
        }

        @NotNull
        public JComponent getComponent() {
            DebuggerExpressionComboBox debuggerExpressionComboBox = this.myComboBox;
            if (debuggerExpressionComboBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider$ExpressionComboBoxPanel", "getComponent"));
            }
            return debuggerExpressionComboBox;
        }

        public void dispose() {
            this.myComboBox.dispose();
        }
    }
}

