/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.inspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ui.CheckBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.GenerateToStringContext;
import org.jetbrains.generate.tostring.GenerateToStringUtils;
import org.jetbrains.generate.tostring.inspection.AbstractToStringInspection;
import org.jetbrains.generate.tostring.inspection.GenerateToStringQuickFix;
import org.jetbrains.generate.tostring.util.StringUtil;

public class ClassHasNoToStringMethodInspection
extends AbstractToStringInspection {
    public String excludeClassNames = "";
    public boolean excludeException = true;
    public boolean excludeDeprecated = true;
    public boolean excludeEnum = false;
    public boolean excludeAbstract = false;
    public boolean excludeTestCode = false;
    public boolean excludeInnerClasses = false;

    @NotNull
    public String getDisplayName() {
        if ("Class does not override 'toString()' method" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection", "getDisplayName"));
        }
        return "Class does not override 'toString()' method";
    }

    @NotNull
    public String getShortName() {
        if ("ClassHasNoToStringMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection", "getShortName"));
        }
        return "ClassHasNoToStringMethod";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitClass(PsiClass clazz) {
                PsiMethod[] superMethods;
                PsiMethod[] toStringMethods;
                String name;
                PsiIdentifier nameIdentifier;
                if (AbstractToStringInspection.log.isDebugEnabled()) {
                    AbstractToStringInspection.log.debug("checkClass: clazz=" + clazz);
                }
                if ((nameIdentifier = clazz.getNameIdentifier()) == null || clazz.getName() == null) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeException && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Throwable")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeDeprecated && clazz.isDeprecated()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeEnum && clazz.isEnum()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeAbstract && clazz.hasModifierProperty("abstract")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeTestCode && TestFrameworks.getInstance().isTestClass(clazz)) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeInnerClasses && clazz.getContainingClass() != null) {
                    return;
                }
                if (StringUtil.isNotEmpty(ClassHasNoToStringMethodInspection.this.excludeClassNames) && (name = clazz.getName()) != null && name.matches(ClassHasNoToStringMethodInspection.this.excludeClassNames)) {
                    return;
                }
                PsiField[] fields = clazz.getFields();
                if (fields.length == 0) {
                    return;
                }
                fields = GenerateToStringUtils.filterAvailableFields(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                PsiMethod[] methods = null;
                if (GenerateToStringContext.getConfig().isEnableMethods()) {
                    methods = GenerateToStringUtils.filterAvailableMethods(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                }
                if (Math.max(fields.length, methods == null ? 0 : methods.length) == 0) {
                    return;
                }
                for (PsiMethod method : toStringMethods = clazz.findMethodsByName("toString", false)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (parameterList.getParametersCount() != 0) continue;
                    return;
                }
                for (PsiMethod method : superMethods = clazz.findMethodsByName("toString", true)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (parameterList.getParametersCount() != 0 || !method.hasModifierProperty("final")) continue;
                    return;
                }
                holder.registerProblem((PsiElement)nameIdentifier, "Class '" + clazz.getName() + "' does not override 'toString()' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{GenerateToStringQuickFix.getInstance()});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/generate/tostring/inspection/ClassHasNoToStringMethodInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)new JLabel("Exclude classes (reg exp):"), constraints);
        final JTextField excludeClassNamesField = new JTextField(this.excludeClassNames, 40);
        excludeClassNamesField.setMinimumSize(new Dimension(140, 20));
        Document document = excludeClassNamesField.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            private void textChanged() {
                ClassHasNoToStringMethodInspection.this.excludeClassNames = excludeClassNamesField.getText();
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 0;
        panel.add((Component)excludeClassNamesField, constraints);
        CheckBox excludeExceptionCheckBox = new CheckBox("Ignore exception classes", (InspectionProfileEntry)this, "excludeException");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)excludeExceptionCheckBox, constraints);
        CheckBox excludeDeprecatedCheckBox = new CheckBox("Ignore deprecated classes", (InspectionProfileEntry)this, "excludeDeprecated");
        constraints.gridy = 2;
        panel.add((Component)excludeDeprecatedCheckBox, constraints);
        CheckBox excludeEnumCheckBox = new CheckBox("Ignore enum classes", (InspectionProfileEntry)this, "excludeEnum");
        constraints.gridy = 3;
        panel.add((Component)excludeEnumCheckBox, constraints);
        CheckBox excludeAbstractCheckBox = new CheckBox("Ignore abstract classes", (InspectionProfileEntry)this, "excludeAbstract");
        constraints.gridy = 4;
        panel.add((Component)excludeAbstractCheckBox, constraints);
        CheckBox excludeInTestCodeCheckBox = new CheckBox("Ignore test classes", (InspectionProfileEntry)this, "excludeTestCode");
        constraints.gridy = 5;
        panel.add((Component)excludeInTestCodeCheckBox, constraints);
        CheckBox excludeInnerClasses = new CheckBox("Ignore inner classes", (InspectionProfileEntry)this, "excludeInnerClasses");
        constraints.gridy = 6;
        constraints.weighty = 1.0;
        panel.add((Component)excludeInnerClasses, constraints);
        return panel;
    }
}

