/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.config.ConflictResolutionPolicy;
import org.jetbrains.generate.tostring.config.DuplicatePolicy;
import org.jetbrains.generate.tostring.config.InsertNewMethodStrategy;

public class ReplacePolicy
implements ConflictResolutionPolicy {
    private static final ReplacePolicy instance = new ReplacePolicy();

    private ReplacePolicy() {
    }

    public static ReplacePolicy getInstance() {
        return instance;
    }

    @Override
    public void setNewMethodStrategy(InsertNewMethodStrategy strategy) {
        DuplicatePolicy.getInstance().setNewMethodStrategy(strategy);
    }

    @Override
    public PsiMethod applyMethod(PsiClass clazz, PsiMethod existingMethod, @NotNull PsiMethod newMethod, Editor editor) throws IncorrectOperationException {
        if (newMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/generate/tostring/config/ReplacePolicy", "applyMethod"));
        }
        PsiMethod generatedMethod = DuplicatePolicy.getInstance().applyMethod(clazz, null, newMethod, editor);
        if (existingMethod != null) {
            existingMethod.delete();
        }
        return generatedMethod;
    }

    public String toString() {
        return "Replace existing";
    }
}

