/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.MemberChooserBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.GenerateToStringActionHandler;
import org.jetbrains.generate.tostring.GenerateToStringConfigurable;
import org.jetbrains.generate.tostring.GenerateToStringContext;
import org.jetbrains.generate.tostring.GenerateToStringUtils;
import org.jetbrains.generate.tostring.GenerateToStringWorker;
import org.jetbrains.generate.tostring.config.Config;
import org.jetbrains.generate.tostring.template.TemplateResource;
import org.jetbrains.generate.tostring.template.TemplatesManager;
import org.jetbrains.generate.tostring.view.TemplatesPanel;

public class GenerateToStringActionHandlerImpl
extends EditorWriteActionHandler
implements GenerateToStringActionHandler {
    private static final Logger logger = Logger.getInstance((String)"#org.jetbrains.generate.tostring.GenerateToStringActionHandlerImpl");

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        PsiClass clazz = GenerateToStringActionHandlerImpl.getSubjectClass(editor, dataContext);
        assert (clazz != null);
        GenerateToStringActionHandlerImpl.doExecuteAction(project, clazz, editor);
    }

    @Override
    public void executeActionQuickFix(Project project, PsiClass clazz) {
        GenerateToStringActionHandlerImpl.doExecuteAction(project, clazz, null);
    }

    private static void doExecuteAction(final @NotNull Project project, final @NotNull PsiClass clazz, final Editor editor) {
        PsiElementClassMember[] dialogMembers;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/generate/tostring/GenerateToStringActionHandlerImpl", "doExecuteAction"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/generate/tostring/GenerateToStringActionHandlerImpl", "doExecuteAction"));
        }
        logger.debug("+++ doExecuteAction - START +++");
        if (logger.isDebugEnabled()) {
            logger.debug("Current project " + project.getName());
        }
        if ((dialogMembers = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz)).length == 0) {
            HintManager.getInstance().showErrorHint(editor, "No members to include in toString() have been found");
            return;
        }
        final MemberChooserBuilder builder = new MemberChooserBuilder(project);
        final MemberChooserHeaderPanel header = new MemberChooserHeaderPanel(clazz);
        builder.setHeaderPanel(header);
        builder.overrideAnnotationVisible(PsiUtil.isLanguageLevel5OrHigher((PsiElement)clazz));
        builder.setTitle("Generate toString()");
        logger.debug("Displaying member chooser dialog");
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                MemberChooser dialog = builder.createBuilder(dialogMembers);
                dialog.setCopyJavadocVisible(false);
                dialog.selectElements(dialogMembers);
                header.setChooser(dialog);
                dialog.show();
                if (0 == dialog.getExitCode()) {
                    List<PsiMember> selectedMembers = GenerateToStringUtils.convertClassMembersToPsiMembers(dialog.getSelectedElements());
                    TemplateResource template = header.getSelectedTemplate();
                    TemplatesManager.getInstance().setDefaultTemplate(template);
                    if (template.isValidTemplate()) {
                        GenerateToStringWorker.executeGenerateActionLater(clazz, editor, selectedMembers, template, dialog.isInsertOverrideAnnotation());
                    } else {
                        HintManager.getInstance().showErrorHint(editor, "toString() template '" + template.getFileName() + "' is invalid");
                    }
                }
            }
        });
        logger.debug("+++ doExecuteAction - END +++");
    }

    public static void updateDialog(PsiClass clazz, MemberChooser<PsiElementClassMember> dialog) {
        ClassMember[] members = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz);
        dialog.resetElements(members);
        dialog.selectElements(members);
    }

    private static PsiElementClassMember[] buildMembersToShow(PsiClass clazz) {
        PsiMethod[] filteredMethods;
        Config config = GenerateToStringContext.getConfig();
        PsiField[] filteredFields = GenerateToStringUtils.filterAvailableFields(clazz, config.getFilterPattern());
        if (logger.isDebugEnabled()) {
            logger.debug("Number of fields after filtering: " + filteredFields.length);
        }
        if (config.enableMethods) {
            filteredMethods = GenerateToStringUtils.filterAvailableMethods(clazz, config.getFilterPattern());
            if (logger.isDebugEnabled()) {
                logger.debug("Number of methods after filtering: " + filteredMethods.length);
            }
        } else {
            filteredMethods = PsiMethod.EMPTY_ARRAY;
        }
        return GenerateToStringUtils.combineToClassMemberList(filteredFields, filteredMethods);
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return GenerateToStringActionHandlerImpl.getSubjectClass(editor, dataContext) != null;
    }

    @Nullable
    private static PsiClass getSubjectClass(Editor editor, DataContext dataContext) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement context = file.findElementAt(offset);
        if (context == null) {
            return null;
        }
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class, (boolean)false);
        if (clazz == null) {
            return null;
        }
        return clazz.isInterface() ? null : clazz;
    }

    public static class MemberChooserHeaderPanel
    extends JPanel {
        private MemberChooser chooser;
        private final JComboBox comboBox;

        public void setChooser(MemberChooser chooser) {
            this.chooser = chooser;
        }

        public MemberChooserHeaderPanel(final PsiClass clazz) {
            super(new BorderLayout());
            Collection<TemplateResource> templates = TemplatesManager.getInstance().getAllTemplates();
            Object[] all = templates.toArray(new TemplateResource[templates.size()]);
            JButton settingsButton = new JButton("Settings");
            settingsButton.setMnemonic(83);
            this.comboBox = new ComboBox(all);
            settingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final TemplatesPanel ui = new TemplatesPanel();
                    Disposable disposable = Disposer.newDisposable();
                    TabbedConfigurable composite = new TabbedConfigurable(disposable){

                        @Override
                        protected List<Configurable> createConfigurables() {
                            ArrayList<Configurable> res = new ArrayList<Configurable>();
                            res.add(new GenerateToStringConfigurable(clazz.getProject()));
                            res.add((Configurable)ui);
                            return res;
                        }

                        public String getDisplayName() {
                            return "toString() Generation Settings";
                        }

                        public String getHelpTopic() {
                            return null;
                        }

                        @Override
                        public void apply() throws ConfigurationException {
                            super.apply();
                            GenerateToStringActionHandlerImpl.updateDialog(clazz, MemberChooserHeaderPanel.this.chooser);
                            MemberChooserHeaderPanel.this.comboBox.removeAllItems();
                            for (TemplateResource resource : TemplatesManager.getInstance().getAllTemplates()) {
                                MemberChooserHeaderPanel.this.comboBox.addItem(resource);
                            }
                            MemberChooserHeaderPanel.this.comboBox.setSelectedItem(TemplatesManager.getInstance().getDefaultTemplate());
                        }
                    };
                    ShowSettingsUtil.getInstance().editConfigurable((Component)MemberChooserHeaderPanel.this, (Configurable)composite, new Runnable(){

                        @Override
                        public void run() {
                            ui.selectItem(TemplatesManager.getInstance().getDefaultTemplate());
                        }
                    });
                    Disposer.dispose((Disposable)disposable);
                }
            });
            this.add((Component)settingsButton, "East");
            this.add((Component)this.comboBox, "Center");
            this.comboBox.setSelectedItem(TemplatesManager.getInstance().getDefaultTemplate());
            JLabel templatesLabel = new JLabel("Template: ");
            templatesLabel.setDisplayedMnemonic('T');
            templatesLabel.setLabelFor(this.comboBox);
            this.add((Component)templatesLabel, "West");
        }

        public TemplateResource getSelectedTemplate() {
            return (TemplateResource)this.comboBox.getSelectedItem();
        }
    }
}

