/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroup;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.frame.StackFrameImplBase;

public final class CallFrameView
extends StackFrameImplBase
implements VariableContext {
    private final DebuggerViewSupport debugProcess;
    private final CallFrame callFrame;
    private final Script script;

    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport debugProcess, @Nullable Script script) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        this(callFrame, debugProcess.getSourceInfo(script, callFrame), debugProcess, script);
    }

    public CallFrameView(@NotNull CallFrame callFrame, @Nullable SourceInfo sourceInfo, @NotNull DebuggerViewSupport debugProcess, @Nullable Script script) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/frame/CallFrameView", "<init>"));
        }
        super(sourceInfo);
        this.debugProcess = debugProcess;
        this.callFrame = callFrame;
        this.script = script;
    }

    @Override
    protected boolean isInFileScope() {
        List<Scope> scopes = this.callFrame.getVariableScopes();
        return scopes.size() == 1 && scopes.get(0).isGlobal();
    }

    @Override
    protected XDebuggerEvaluator createEvaluator() {
        return this.debugProcess.createFrameEvaluator(this);
    }

    public Object getEqualityObject() {
        return this.callFrame;
    }

    @Override
    protected void customizeInvalidFramePresentation(ColoredTextContainer component) {
        assert (this.sourceInfo == null);
        String scriptName = this.script == null ? "unknown" : this.script.getUrl().trimParameters().toDecodedForm();
        int line = this.callFrame.getLine();
        component.append(line != -1 ? scriptName + ':' + line : scriptName, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/frame/CallFrameView", "computeChildren"));
        }
        node.setAlreadySorted(true);
        ScopeVariablesGroup.createAndAddScopeList(node, this.callFrame.getVariableScopes(), this, this.callFrame);
    }

    @NotNull
    public CallFrame getCallFrame() {
        CallFrame callFrame = this.callFrame;
        if (callFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getCallFrame"));
        }
        return callFrame;
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        EvaluateContext evaluateContext = this.callFrame.getEvaluateContext();
        if (evaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getEvaluateContext"));
        }
        return evaluateContext;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    @Nullable
    public VariableContext getParent() {
        return null;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getDebugProcess() {
        DebuggerViewSupport debuggerViewSupport = this.debugProcess;
        if (debuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getDebugProcess"));
        }
        return debuggerViewSupport;
    }

    @Override
    @NotNull
    public MemberFilter getMemberFilter() {
        DebuggerViewSupport debuggerViewSupport = this.debugProcess;
        if (debuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/CallFrameView", "getMemberFilter"));
        }
        return debuggerViewSupport;
    }

    @Override
    @Nullable
    public Scope getScope() {
        return null;
    }
}

